% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotateFromBiomart.R
\name{annotateFromBiomart}
\alias{annotateFromBiomart}
\title{Annotate your Expression Set with biomaRt}
\usage{
annotateFromBiomart(obj, genes = featureNames(obj),
  filters = "ensembl_gene_id", attributes = c("ensembl_gene_id",
  "hgnc_symbol", "chromosome_name", "start_position", "end_position"),
  biomart = "ensembl", dataset = "hsapiens_gene_ensembl", ...)
}
\arguments{
\item{obj}{ExpressionSet object.}

\item{genes}{Genes or rownames of the ExpressionSet.}

\item{filters}{getBM filter value, see getBM help file.}

\item{attributes}{getBM attributes value, see getBM help file.}

\item{biomart}{BioMart database name you want to connect to. Possible database names can be retrieved with teh function listMarts.}

\item{dataset}{Dataset you want to use. To see the different datasets available within a biomaRt you can e.g. do: mart = useMart('ensembl'), followed by listDatasets(mart).}

\item{...}{Values for useMart, see useMart help file.}
}
\value{
ExpressionSet object with a fuller featureData.
}
\description{
Annotate your Expression Set with biomaRt
}
\examples{

data(skin)
# subsetting and changing column name just for a silly example
skin <- skin[1:10,]
colnames(fData(skin)) = paste("names",1:6)
biomart<-"ENSEMBL_MART_ENSEMBL";
genes <- sapply(strsplit(rownames(skin),split="\\\\."),function(i)i[1])
newskin <-annotateFromBiomart(skin,genes=genes,biomar=biomart)
head(fData(newskin)[,7:11])

}
