% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-xcmsRaw.R
\name{findPeaks.MSW,xcmsRaw-method}
\alias{findPeaks.MSW,xcmsRaw-method}
\alias{findPeaks.MSW}
\title{Peak detection for single-spectrum non-chromatography MS data}
\usage{
\S4method{findPeaks.MSW}{xcmsRaw}(object, snthresh = 3, verbose.columns = FALSE, ...)
}
\arguments{
\item{object}{The \code{xcmsRaw} object on which peak
detection should be performed.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{verbose.columns}{Logical whether additional peak meta data columns
should be returned.}

\item{...}{Additional parameters to be passed to the
\code{peakDetectionCWT()} and
\code{identifyMajorPeaks()} functions from the
\emph{MassSpecWavelet} package.}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{A matrix, each row representing an intentified peak.
}\if{html}{\out{</div>}}
}
\description{
This method performs peak detection in mass spectrometry
direct injection spectrum using a wavelet based algorithm.
}
\details{
This is a wrapper around the peak picker in Bioconductor's
\emph{MassSpecWavelet} package calling
\code{peakDetectionCWT} and
\code{tuneInPeakInfo} functions.
}
\author{
Joachim Kutzera, Steffen Neumann, Johannes Rainer
}
