% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_findChromPeaks-functions.R
\name{do_findPeaks_MSW}
\alias{do_findPeaks_MSW}
\title{Core API function for single-spectrum non-chromatography MS data
peak detection}
\usage{
do_findPeaks_MSW(
  mz,
  int,
  snthresh = 3,
  verboseColumns = FALSE,
  scantime = numeric(),
  valsPerSpect = integer(),
  ...
)
}
\arguments{
\item{mz}{Numeric vector with the individual m/z values from all scans/
spectra of one file/sample.}

\item{int}{Numeric vector with the individual intensity values from all
scans/spectra of one file/sample.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{verboseColumns}{\code{logical(1)} whether additional peak meta data
columns should be returned.}

\item{scantime}{ignored.}

\item{valsPerSpect}{ignored.}

\item{...}{Additional parameters to be passed to the
\code{peakDetectionCWT} function.}
}
\value{
A matrix, each row representing an identified peak, with columns:
\itemize{
\item \code{"mz"}: m/z value of the peak at the centroid position.
\item \code{"mzmin"}: Minimum m/z of the peak.
\item \code{"mzmax"}: Maximum m/z of the peak.
\item \code{"rt"}: Always \code{-1}.
\item \code{"rtmin"}: Always \code{-1}.
\item \code{"rtmax"}: Always \code{-1}.
\item \code{"into"}: Integrated (original) intensity of the peak.
\item \code{"maxo"}: Maximum intensity of the peak.
\item \code{"intf"}: Always \code{NA}.
\item \code{"maxf"}: Maximum MSW-filter response of the peak.
\item \code{"sn"}: Signal to noise ratio.
}
}
\description{
This function performs peak detection in mass spectrometry
direct injection spectrum using a wavelet based algorithm.
}
\details{
This is a wrapper around the peak picker in Bioconductor's
\emph{MassSpecWavelet} package calling
\code{peakDetectionCWT()} and \code{tuneInPeakInfo()} functions. See the
\emph{xcmsDirect} vignette for more information.
}
\seealso{
Other core peak detection functions: 
\code{\link{do_findChromPeaks_centWave}()},
\code{\link{do_findChromPeaks_centWaveWithPredIsoROIs}()},
\code{\link{do_findChromPeaks_massifquant}()},
\code{\link{do_findChromPeaks_matchedFilter}()}
}
\author{
Joachim Kutzera, Steffen Neumann, Johannes Rainer
}
\concept{core peak detection functions}
