% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WPPI_functions.R
\name{in_omnipath}
\alias{in_omnipath}
\title{Check which genes of interest are or not in OmniPath}
\usage{
in_omnipath(graph_op, gene_set, in_network = TRUE)
}
\arguments{
\item{graph_op}{Igraph object based on OmniPath PPI interactions from
\code{\link{graph_from_op}}.}

\item{gene_set}{Character vector with known-disease specific genes from
which is built the functional weighted PPI.}

\item{in_network}{Logical: whether to return the genes in the network or
the missing ones.}
}
\value{
Character vector with genes corresponding to the query.
}
\description{
Check which genes of interest are or not in OmniPath
}
\examples{
# genes mapped and not mapped in OmniPath
graph_op <- graph_from_op(wppi_omnipath_data())
genes_interest <-
    c("ERCC8", "AKT3", "NOL3", "GFI1B", "CDC25A", "TPX2", "SHE")
genes_mapped <- in_omnipath(graph_op, genes_interest, 1)
genes_notmapped <- in_omnipath(graph_op, genes_interest, 0)

}
\seealso{
\itemize{
    \item{\code{\link{wppi_omnipath_data}}}
    \item{\code{\link{graph_from_op}}}
}
}
