% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_wrapper_wpm.R
\name{wrapperWPM}
\alias{wrapperWPM}
\title{Generate plate plans in a single step}
\usage{
wrapperWPM(
  user_df,
  plate_dims,
  nb_plates,
  forbidden_wells = NULL,
  buffer_wells = NULL,
  fixed_wells = NULL,
  spatial_constraint = "none",
  max_iteration = 20
)
}
\arguments{
\item{user_df}{dataframe containing user data obtained with the
`convertCSV()` or `convertESet()` functions.}

\item{plate_dims}{list, containing 2 values: the first is the number of
plate's lines and second is the number of plate's columns.}

\item{nb_plates}{numeric, corresponds to the number of plates to fill}

\item{forbidden_wells}{character, the wells that will not be used at all
for the experiment. This argument needs to be a character string giving the
 wells coordinates of the form "LetterNumber" (eg. "A1" for the well
 positionned in the first row/ first column of the plate).}

\item{buffer_wells}{character, the wells that will be used during
experiment but without biological sample in it. Same input structure as for
forbidden_wells parameter.}

\item{fixed_wells}{character, the wells that will be used for Quality Control
samples or standards during the Experiment. Same input structure as for forbidden_wells
parameter.}

\item{spatial_constraint}{character, is the spatial constraint used to
place the samples on the plate. It can also be called neighborhood
constraint. Currently, the possible values are "none", "NS" (for
North-South), "WE" (for West-East) and "NEWS" (North-South-East-West).}

\item{max_iteration}{numeric, maximal number of attemps for wpm to find a
valid solution.}
}
\value{
a dataframe if wpm finds a solution.
}
\description{
Wrapper function that generates plate plans like the wpm
shiny application. This feature allows the user to use the wpm package
from the command line rather than going through a web application.
}
\examples{
# create a MSnSet toy example
sample_names <- c("s1","s2","s3","s4", "s5")
M <- matrix(NA, nrow = 4, ncol = 5)
colnames(M) <- sample_names
rownames(M) <- paste0("id", LETTERS[1:4])
pd <- data.frame(Environment = rep_len(LETTERS[1:3], 5),
                 Category = rep_len(1:2, 5), row.names = sample_names)
rownames(pd) <- colnames(M)
x <- MSnbase::MSnSet(exprs = M,pData =  pd)
# convert it to a valid dataframe for wpm
df <- convertESet(x, "Environment")
# run wpm on the toy example
wrapperWPM(user_df = df, plate_dims = list(8,12), nb_plates = 1,
           forbidden_wells = "A1,A2,A3", fixed_wells = "B1,B2",
           spatial_constraint = "NS")
}
