% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrapperFuncs.R
\name{estimClustNum}
\alias{estimClustNum}
\title{Wrapper for estimation of cluster number}
\usage{
estimClustNum(dat, maxClust = 25, scaling = "standardize", cores = 1)
}
\arguments{
\item{dat}{matrix of features averaged over replicates. The last column
contains their standard deviation}

\item{maxClust}{Maximal number of cluster. The minimum is 3}

\item{scaling}{Either `standardize` (default), `center` or `none`. Standardized 
features get mean 0 and standard deviation 1. Centered samples get mean 0.}

\item{cores}{The number of threads to be used for parallelisation}
}
\value{
list with the items `ClustInd`: list of clustering objects for each
number of clusters, `p` plot object with plots for validity indices,
`numclust` optimal cluster number according to "minimum centroid distance"
}
\description{
This runs the clustering for different numbers of clusters, and estimates the
most suitable numbers from applying the minimum centroid distance and the Xie
Beni index. Multi-threading is used to shorten the computation times.
Given the hierarchical structure of many data sets, the resulting numbers are
suggestions. Inspection of the here plotted indices help to determine
alternative cluster numbers, given by a strong decay of the minimum centroid
distance and/or a low value of the Xie Beni index.
}
\examples{
data <- matrix(rnorm(1000), nrow=100)
estim_out <- estimClustNum(data, maxClust=10)
best_number <- which.max(estim_out[1]) + 2
}
