% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_overlapping.R
\name{merge_overlapping}
\alias{merge_overlapping}
\title{Merge overlapping spots}
\usage{
merge_overlapping(spe)
}
\arguments{
\item{spe}{A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
with \code{colData(spe)} columns
\code{array_row}, \code{array_col}, \code{key}, \code{group}, and
\code{capture_area}.}
}
\value{
A \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment}
with at most one spot per array location
}
\description{
Given a stitched \link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class},
merge overlapping (same array coordinates) spots by adding
expression (i.e. from \code{assays(spe)$counts}), returning a
\code{SpatialExperiment} with at most one spot per array location.
}
\details{
\code{colData(spe)} and \code{spatialCoords(spe)} of the merged spots are
taken from the spots whose \code{exclude_overlapping} values are \code{TRUE}.
}
\examples{
if (!exists("spe")) {
    spe <- spatialLIBD::fetch_data(type = "visiumStitched_brain_spe")
}

#   Group colData by group and array coordinates
grouped_coldata <- colData(spe) |>
    dplyr::as_tibble() |>
    dplyr::group_by(group, array_row, array_col)

#   Find the first 100 keys that overlap other spots and don't, respectively
overlapping_keys <- grouped_coldata |>
    dplyr::filter(dplyr::n() > 1) |>
    dplyr::slice_head(n = 2) |>
    dplyr::ungroup() |>
    dplyr::slice_head(n = 100) |>
    dplyr::pull(key)
nonoverlapping_keys <- grouped_coldata |>
    dplyr::filter(dplyr::n() == 1) |>
    dplyr::ungroup() |>
    dplyr::slice_head(n = 100) |>
    dplyr::pull(key)

#   Built a small SPE containing some overlaps and some non-overlapping spots
small_spe <- spe[, c(overlapping_keys, nonoverlapping_keys)]

#   Merge overlapping spots
small_spe_merged <- merge_overlapping(small_spe)

#   All array coordinates have just one unique spot after merging
colData(small_spe_merged) |>
    dplyr::as_tibble() |>
    dplyr::group_by(group, array_row, array_col) |>
    dplyr::summarize(n = dplyr::n()) |>
    dplyr::pull(n) |>
    table()

}
\author{
Nicholas J. Eagles
}
