% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich_motifs.R
\name{enrich_motifs}
\alias{enrich_motifs}
\title{Enrich for input motifs in a set of sequences.}
\usage{
enrich_motifs(motifs, sequences, bkg.sequences, max.p = 0.001,
  max.q = 0.001, max.e = 0.001, qval.method = "fdr", threshold = 1e-04,
  threshold.type = "pvalue", verbose = 0, RC = TRUE, use.freq = 1,
  shuffle.k = 2, shuffle.method = "euler", return.scan.results = FALSE,
  nthreads = 1, rng.seed = sample.int(10000, 1), motif_pvalue.k = 8,
  use.gaps = TRUE, allow.nonfinite = FALSE, warn.NA = TRUE,
  no.overlaps = TRUE, no.overlaps.by.strand = FALSE,
  no.overlaps.strat = "score", respect.strand = FALSE,
  motif_pvalue.method = c("dynamic", "exhaustive"),
  scan_sequences.qvals.method = c("BH", "fdr", "bonferroni"),
  mode = c("total.hits", "seq.hits"), pseudocount = 1)
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable motif formats.}

\item{sequences}{\code{\link{XStringSet}} Sequences to scan. Alphabet
should match motif.}

\item{bkg.sequences}{\code{\link{XStringSet}} Optional. If missing,
\code{\link[=shuffle_sequences]{shuffle_sequences()}} is used to create background sequences from
the input sequences.}

\item{max.p}{\code{numeric(1)} P-value threshold.}

\item{max.q}{\code{numeric(1)} Adjusted P-value threshold. This is only useful
if multiple motifs are being enriched for.}

\item{max.e}{\code{numeric(1)}. The E-value is calculated by multiplying the
P-value with the number of input motifs times two
(McLeay and Bailey 2010).}

\item{qval.method}{\code{character(1)} See \code{\link[stats:p.adjust]{stats::p.adjust()}}.}

\item{threshold}{\code{numeric(1)} See details.}

\item{threshold.type}{\code{character(1)} One of \code{c('pvalue', 'qvalue', 'logodds', 'logodds.abs')}. See details.}

\item{verbose}{\code{numeric(1)} 0 for no output, 4 for max verbosity.}

\item{RC}{\code{logical(1)} If \code{TRUE}, check reverse complement of the input
sequences. Only available for DNA/RNA.}

\item{use.freq}{\code{numeric(1)} The default, 1, uses the motif matrix (from
the \code{motif['motif']} slot) to search for sequences. If a higher
number is used, then the matching k-let matrix from the
\code{motif['multifreq']} slot is used. See \code{\link[=add_multifreq]{add_multifreq()}}.}

\item{shuffle.k}{\code{numeric(1)} The k-let size to use when shuffling input
sequences. Only used if no background sequences are input. See
\code{\link[=shuffle_sequences]{shuffle_sequences()}}.}

\item{shuffle.method}{\code{character(1)} One of \code{c('euler', 'markov', 'linear')}.
See \code{\link[=shuffle_sequences]{shuffle_sequences()}}.}

\item{return.scan.results}{\code{logical(1)} Return output from
\code{\link[=scan_sequences]{scan_sequences()}}. For large jobs, leaving this as
\code{FALSE} can save a small amount time by preventing construction of the complete
results \code{data.frame} from \code{\link[=scan_sequences]{scan_sequences()}}.}

\item{nthreads}{\code{numeric(1)} Run \code{\link[=scan_sequences]{scan_sequences()}} in parallel with \code{nthreads}
threads. \code{nthreads = 0} uses all available threads.
Note that no speed up will occur for jobs with only a single motif and
sequence.}

\item{rng.seed}{\code{numeric(1)} Set random number generator seed. Since shuffling
can occur simultaneously in multiple threads using C++, it cannot communicate
with the regular \code{R} random number generator state and thus requires an
independent seed. Each individual sequence in an \code{\link{XStringSet}} object
will be given the following seed: \code{rng.seed * index}. See \code{\link[=shuffle_sequences]{shuffle_sequences()}}.}

\item{motif_pvalue.k}{\code{numeric(1)} Control \code{\link[=motif_pvalue]{motif_pvalue()}} approximation.
See \code{\link[=motif_pvalue]{motif_pvalue()}}.}

\item{use.gaps}{\code{logical(1)} Set this to \code{FALSE} to ignore motif gaps, if
present.}

\item{allow.nonfinite}{\code{logical(1)} If \code{FALSE}, then apply a pseudocount if
non-finite values are found in the PWM. Note that if the motif has a
pseudocount greater than zero and the motif is not currently of type PWM,
then this parameter has no effect as the pseudocount will be
applied automatically when the motif is converted to a PWM internally. This
value is set to \code{FALSE} by default in order to stay consistent with
pre-version 1.8.0 behaviour. A message will be printed if a pseudocount
is applied. To disable this, set \code{options(pseudocount.warning=FALSE)}.}

\item{warn.NA}{\code{logical(1)} Whether to warn about the presence of non-standard
letters in the input sequence, such as those in masked sequences.}

\item{no.overlaps}{\code{logical(1)} Remove overlapping hits from the same motifs.
Overlapping hits from different motifs are preserved. Please note that the
current implementation of this feature can add significantly to the run
time for large inputs.}

\item{no.overlaps.by.strand}{\code{logical(1)} Whether to discard overlapping hits
from the opposite strand (\code{TRUE}), or to only discard overlapping hits on the
same strand (\code{FALSE}).}

\item{no.overlaps.strat}{\code{character(1)} One of \code{c("score", "order")}.
The former option keeps the highest scoring overlapping hit (and the first
of these within ties), and the latter simply keeps the first overlapping hit.}

\item{respect.strand}{\code{logical(1)} If  motifs are DNA/RNA,
then setting this option to \code{TRUE} will make \code{scan_sequences()} only
scan the strands of the input sequences as indicated in the motif
\code{strand} slot.}

\item{motif_pvalue.method}{\code{character(1)} One of \code{c("dynamic", "exhaustive")}.
Algorithm used for calculating P-values. The \code{"exhaustive"} method
involves finding all possible motif matches at or above the specified
score using a branch-and-bound algorithm, which can be computationally
intensive (Hartman et al., 2013). Additionally, the computation
must be repeated for each hit. The \code{"dynamic"} method calculates the
distribution of possible motif scores using a much faster dynamic
programming algorithm, and can be recycled for multiple
scores (Grant et al., 2011). The only
disadvantage is the inability to use \code{allow.nonfinite = TRUE}.
See \code{\link[=motif_pvalue]{motif_pvalue()}} for details.}

\item{scan_sequences.qvals.method}{\code{character(1)} One of
\code{c("fdr", "BH", "bonferroni")}. The method for calculating adjusted
P-values for individual motif hits. These are described in depth in the
Sequence Searches vignette.}

\item{mode}{\code{character(1)} One of \code{c("total.hits", "seq.hits")}. The former
enriches for the total count of motif hits across all sequences,
whereas the latter only counts motif hits once per sequence (useful for
cases where there are many small sequences).}

\item{pseudocount}{\code{integer(1)} Add a pseudocount to the motif hit counts
when performing the Fisher test.}
}
\value{
\code{DataFrame} Enrichment results in a \code{DataFrame}. Function args and
(optionally) scan results are stored in the \code{metadata} slot.
}
\description{
Given a set of target and background sequences, test if the input motifs
are significantly enriched in the targets sequences relative to the
background sequences. See the "Sequence manipulation and scanning" vignette.
}
\details{
To find enriched motifs, \code{\link[=scan_sequences]{scan_sequences()}} is run on both
target and background sequences.
\code{\link[stats:fisher.test]{stats::fisher.test()}} is run to test for enrichment.

See \code{\link[=scan_sequences]{scan_sequences()}} for more info on scanning parameters.
}
\examples{
data(ArabidopsisPromoters)
data(ArabidopsisMotif)
if (R.Version()$arch != "i386") {
enrich_motifs(ArabidopsisMotif, ArabidopsisPromoters, threshold = 0.01)
}

}
\references{
McLeay R, Bailey TL (2010). “Motif Enrichment Analysis: A unified
framework and method evaluation.” \emph{BMC Bioinformatics}, \strong{11}.
}
\seealso{
\code{\link[=scan_sequences]{scan_sequences()}}, \code{\link[=shuffle_sequences]{shuffle_sequences()}},
\code{\link[=add_multifreq]{add_multifreq()}}, \code{\link[=motif_pvalue]{motif_pvalue()}}
}
\author{
Benjamin Jean-Marie Tremblay \email{benjamin.tremblay@uwaterloo.ca}
}
