% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wellNameSort.R
\name{sortDataFrame}
\alias{sortDataFrame}
\title{Sorts a data frame according to the well names.}
\usage{
sortDataFrame(df, sortByLetter = FALSE)
}
\arguments{
\item{df}{A data frame with row names of the form A01, A02, B01, etc.}

\item{sortByLetter}{If \code{TRUE}, the resulting list is sorted by the
letter in the well names first, e.g. "A02" comes before "B01". If
\code{FALSE}, the result is sorted by the numeric component of the well
names first, e.g. "B01" comes before "A02". Defaults to \code{FALSE}.}
}
\value{
The data frame \code{df} with the rows sorted.
}
\description{
Well names can be sorted according to the leading letter or the trailing
digit.
}
\examples{
## Sort a subset of the KRAScounts data frame.
df <- KRAScounts[, c("Ratio", "FracAbun")]
sortDataFrame(df=df, sortByLetter=FALSE)
sortDataFrame(df=df, sortByLetter=TRUE)

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
