% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseCounts.R
\name{parseClusterCounts}
\alias{parseClusterCounts}
\title{Retain cluster counts and user-specified columns in data frames.}
\usage{
parseClusterCounts(
  df,
  rows = NULL,
  rowID = NULL,
  keepCols = NULL,
  keepColNames = NULL
)
}
\arguments{
\item{df}{A data frame with droplet count columns in one of the following
formats:
\itemize{
  \item{\code{PP}, \code{PN}, \code{NP}, \code{NN}};
  \item{\code{Ch1.Ch2.}, \code{Ch1.Ch2..1}, \code{Ch1.Ch2..2},
  \code{Ch1.Ch2..3}};
  \item{\code{Ch1+Ch2+}, \code{Ch1+Ch2-}, \code{Ch1-Ch2+}, \code{Ch1-Ch2-}};
  or
  \item{\code{Ch1pCh2p}, \code{Ch1pCh2n}, \code{Ch1nCh2p}, \code{Ch1nCh2n}}.
}}

\item{rows}{A vector of rows (numbers or well names) to keep from the
original data frame. If set to \code{NULL}, all wells will be used. Defaults
to \code{NULL}.}

\item{rowID}{If set, this field is used as the row names. If \code{NULL},
the existing row names from \code{df} are used. Defaults to \code{NULL}.}

\item{keepCols}{A vector of columns to keep from \code{df}. If \code{NULL},
no extra columns are added. Defaults to \code{NULL}.}

\item{keepColNames}{A vector of new column names for \code{keepCols}. If
\code{NULL}, the column names from \code{keepCols} are reused. Defaults to
\code{NULL}.}
}
\value{
A data frame with the counts in the \code{PP}, \code{PN}, \code{PN}
and \code{PN} convention.
}
\description{
Take a data frame of droplet counts and returns only the raw "PP", "PN",
"NP" and "NN" counts, plus any additional columns specified.
}
\examples{
## Take a data frame with row names given by the well names. Get a simple
## count of droplets in each cluster.
parseClusterCounts(KRAScounts)

## Keep only the row numbers 3, 6 and 9.
parseClusterCounts(KRAScounts, rows=c(3, 6, 9))

## Keep only the rows labelled "F03", "A04", "D04".
parseClusterCounts(KRAScounts, rows=c("F03", "A04", "D04"))

## Take a data frame with a 'Well' column and do the same as above.
parseClusterCounts(KRAScountsWellCol, rowID="Well")

## Keep the 'InputAmount' column.
parseClusterCounts(KRAScounts, keepCols=c("InputAmount"))

## Keep the 'InputAmount' column and rename it.
parseClusterCounts(KRAScounts, keepCols=c("InputAmount"),
                   keepColNames=c("NanogramsIn"))

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
