% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseCounts.R
\name{.numberOfWells}
\alias{.numberOfWells}
\title{Find the number of wells in the data frame.}
\usage{
.numberOfWells(df)
}
\arguments{
\item{df}{A data frame of droplet counts with a \code{Well} column.}
}
\value{
An integer giving the number of wells.
}
\description{
Auxiliary function to find the number of wells that appear in the data
frame, each with the same frequency (almost certainly once or twice). If
some wells appear more than others, the function stops because the data is
in an unknown format.
}
\details{
Bio-Rad's QuantaSoft produces data in long form tables, i.e. for each well
there is a row for each target such as mutant and wild type. In this
package, we prefer to work with wide form tables that combine the mutant and
wild type parts.
}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
