% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runDS.R
\name{runDS}
\alias{runDS}
\title{Test for differential state using edgeR}
\usage{
runDS(
  SE,
  tree,
  option = c("glm", "glmQL"),
  design = NULL,
  contrast = NULL,
  filter_min_count = 1,
  filter_min_total_count = 15,
  filter_large_n = 10,
  filter_min_prop = 1,
  min_cells = 10,
  normalize = TRUE,
  normalize_method = "TMM",
  group_column = "group_id",
  design_terms = "group_id",
  message = TRUE,
  ...
)
}
\arguments{
\item{SE}{A \code{SummarizedExperiment} object, typically generated by
\code{aggDS}.}

\item{tree}{A \code{phylo} object. Each \strong{assay} of \code{SE}
stores data for one node of the tree.}

\item{option}{Either \code{"glm"} or \code{"glmQL"}. If \code{"glm"},
\code{\link[edgeR]{glmFit}} and \code{\link[edgeR]{glmLRT}} are used;
otherwise, \code{\link[edgeR]{glmQLFit}} and
\code{\link[edgeR]{glmQLFTest}} are used. Details about the difference
between two options are in the help page of
\code{\link[edgeR]{glmQLFit}}.}

\item{design}{A numeric design matrix. If \code{NULL}, all columns of
the sample annotation will be used to create the design matrix.}

\item{contrast}{A numeric vector specifying one contrast of
the linear model coefficients to be tested equal to zero. Its length
must equal to the number of columns of design. If \code{NULL}, the last
coefficient will be tested equal to zero.}

\item{filter_min_count}{A numeric value, passed to \strong{min.count} of
\code{\link[edgeR]{filterByExpr}}.}

\item{filter_min_total_count}{A numeric value, passed to
\strong{min.total.count} of \code{\link[edgeR]{filterByExpr}}.}

\item{filter_large_n}{A numeric value, passed to \strong{large.n} of
\code{\link[edgeR]{filterByExpr}}.}

\item{filter_min_prop}{A numeric value, passed to \strong{min.prop} of
\code{\link[edgeR]{filterByExpr}}.}

\item{min_cells}{A numeric scalar specifying the minimal number of cells
in a node required to include a node in the analysis. The information
about the number of cells per node and sample should be available in
\code{metadata(SE)$n_cells}. A node is retained if at least half of the
samples have at least \code{min_cells} cells belonging to the node.}

\item{normalize}{A logical scalar indicating whether to estimate
normalization factors (using \code{\link[edgeR]{calcNormFactors}}).}

\item{normalize_method}{Normalization method to be used. See
\code{\link[edgeR]{calcNormFactors}} for more details.}

\item{group_column}{The name of the column in the sample annotation
providing group labels for samples. This annotation is used for
filtering.}

\item{design_terms}{The names of columns from the sample annotation
that will be used to generate the design matrix. This is ignored if
\strong{design} is provided.}

\item{message}{A logical scalar, indicating whether progress messages
should be printed.}

\item{...}{More arguments to pass to \code{\link[edgeR]{glmFit}}
(\code{option = "glm"} or \code{\link[edgeR]{glmQLFit}}
(\code{option = "glmQL"}).}
}
\value{
A list with entries \strong{edgeR_results}, \strong{tree}, and
\strong{nodes_drop}.
\describe{
    \item{edgeR_results}{A list. Each of the elements contains the output of
         \code{\link[edgeR]{glmQLFTest}} or
         \code{\link[edgeR]{glmLRT}} for one node, depending on the specified
         \code{option}.}
    \item{tree}{The hierarchical structure of entities that was stored in the
         input \code{SE}.}
    \item{nodes_drop}{A vector storing the alias node labels of entities
         that are filtered before analysis due to low counts.}
}
}
\description{
Test for differential state of entities using functions from the
\code{\link[edgeR:edgeR-package]{edgeR}} package. This adapts
\code{\link{edgerWrp}} to accept input as a
\code{\link[SummarizedExperiment]{SummarizedExperiment}} (SE) object
instead of \code{matrix}. Each \code{assay} should correspond to data
for one node of the tree. Samples are in columns and
features are in rows. The sample information is
in \code{colData}. The tree that stores the hierarchical relation between
the \code{assays} is provided via the argument \code{tree}.
}
\examples{
suppressPackageStartupMessages({
    library(TreeSummarizedExperiment)
})
## Load example data
ds_tse <- readRDS(system.file("extdata", "ds_sim_20_500_8de.rds",
                              package = "treeclimbR"))
ds_se <- aggDS(TSE = ds_tse, assay = "counts", sample_id = "sample_id",
               group_id = "group", cluster_id = "cluster_id", FUN = sum)
## Information about the number of cells is provided in the metadata
S4Vectors::metadata(ds_se)$n_cells

ds_res <- runDS(SE = ds_se, tree = colTree(ds_tse), option = "glmQL",
                group_column = "group", contrast = c(0, 1),
                filter_min_count = 0, filter_min_total_count = 1,
                design = model.matrix(~ group, data = colData(ds_se)),
                filter_min_prop = 0, min_cells = 5, message = FALSE)
## Top differential features (across nodes)
nodeResult(ds_res, type = "DS")

}
\author{
Ruizhu Huang
}
