% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_findExcl.R
\name{findExcl}
\alias{findExcl}
\title{Find branches that are non-overlapping with specified branches in a tree}
\usage{
findExcl(tree, node, use.alias = FALSE)
}
\arguments{
\item{tree}{A \code{phylo} object.}

\item{node}{A numeric or character vector specifying the nodes.}

\item{use.alias}{A logical scalar. If \code{TRUE}, the alias name is
used to name the output vector.}
}
\value{
A vector of node numbers
}
\description{
Find all branches whose leaves do not overlap with those of the specified
branches.
}
\examples{
suppressPackageStartupMessages({
    library(ggtree)
    library(TreeSummarizedExperiment)
})

data(tinyTree)
ggtree(tinyTree, branch.length = "none") +
    geom_text2(aes(label = node)) +
    geom_hilight(node = 17, fill = "blue", alpha = 0.3) +
    geom_hilight(node = 13, fill = "orange", alpha = 0.3)

## Find branches whose leaves do not overlap with the two colored branches.
## The returned branches are represented at the highest tree level
## possible without including any of the forbidden branches.
findExcl(tree = tinyTree, node = c(17, 13))

}
\author{
Ruizhu Huang
}
