% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k-mer-based.R
\name{compute_kmer_enrichment}
\alias{compute_kmer_enrichment}
\title{\emph{k}-mer Enrichment between Foreground and Background Sets}
\usage{
compute_kmer_enrichment(
  foreground_kmers,
  background_kmers,
  permutation = FALSE,
  chisq_p_value_threshold = 0.05,
  p_adjust_method = "BH"
)
}
\arguments{
\item{foreground_kmers}{\emph{k}-mer counts of the foreground set
(generated by \code{\link{generate_kmers}})}

\item{background_kmers}{\emph{k}-mer counts of the background set
(generated by \code{\link{generate_kmers}})}

\item{permutation}{if \code{TRUE}, only the enrichment value is returned
(efficiency mode
used for permutation testing)}

\item{chisq_p_value_threshold}{threshold below which Fisher's exact test
is used instead of Pearson's chi-squared test}

\item{p_adjust_method}{see \code{\link[stats]{p.adjust}}}
}
\value{
enrichment of \emph{k}-mers in specified foreground sequences.
A data frame with the following columns is returned:
\tabular{rl}{
  \code{foreground_count} \tab foreground counts for each \emph{k}-mer\cr
  \code{background_count} \tab background counts for each \emph{k}-mer\cr
  \code{enrichment} \tab \emph{k}-mer enrichment\cr
  \code{p_value} \tab p-value of \emph{k}-mer enrichment (either from
  Fisher's exact test or Pearson's chi-squared test)\cr
  \code{adj_p_value} \tab multiple testing corrected p-value\cr
}
}
\description{
Compares foreground sequence set to background sequence set and computes
enrichment values
for each possible \emph{k}-mer.
}
\details{
Usually uses Pearson's chi-squared test, but recalculates p-values
with Fisher's exact test
for Pearson's chi-squared test p-values \code{<= chisq_p_value_threshold}.
The reason this is done is
computational efficiency. Fisher's exact tests are computationally
demanding and are only
performed in situations, where exact p-values are preferred, e.g.,
if expected < 5 or
significant p-values.
}
\examples{
# define simple sequence sets for foreground and background
foreground_set <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA"
)
background_set <- c(
  "CAACAGCCUUAAUU", "CAGUCAAGACUCC", "CUUUGGGGAAU",
  "UCAUUUUAUUAAA", "AAUUGGUGUCUGGAUACUUCCCUGUACAU",
  "AUCAAAUUA", "AGAU", "GACACUUAAAGAUCCU",
  "UAGCAUUAACUUAAUG", "AUGGA", "GAAGAGUGCUCA",
  "AUAGAC", "AGUUC", "CCAGUAA",
  "UUAUUUA", "AUCCUUUACA", "UUUUUUU", "UUUCAUCAUU",
  "CCACACAC", "CUCAUUGGAG", "ACUUUGGGACA", "CAGGUCAGCA"
)
foreground_kmers <- generate_kmers(foreground_set, 6)
background_kmers <- generate_kmers(background_set, 6)


kmer_enrichment_values <- compute_kmer_enrichment(foreground_kmers,
  background_kmers)
}
\seealso{
Other \emph{k}-mer functions: 
\code{\link{calculate_kmer_enrichment}()},
\code{\link{check_kmers}()},
\code{\link{count_homopolymer_corrected_kmers}()},
\code{\link{create_kmer_origin_list}()},
\code{\link{draw_volcano_plot}()},
\code{\link{estimate_significance}()},
\code{\link{estimate_significance_core}()},
\code{\link{generate_kmers}()},
\code{\link{generate_permuted_enrichments}()},
\code{\link{run_kmer_spma}()},
\code{\link{run_kmer_tsma}()}
}
\concept{\emph{k}-mer functions}
