% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllMethods.R
\docType{methods}
\name{orderingProperties}
\alias{orderingProperties}
\alias{orderingProperties,Transcriptogram-method}
\alias{orderingProperties-method}
\title{Calculates graph properties projected on the ordered proteins}
\usage{
orderingProperties(object, nCores = 1L)

\S4method{orderingProperties}{Transcriptogram}(object, nCores = 1L)
}
\arguments{
\item{object}{An object of class Transcriptogram.}

\item{nCores}{An integer number, referring to the number of processing cores
to be used; or a logical value, TRUE indicating that all processing cores
should be used, and FALSE indicating the use of just one processing core.
The default value of this argument is 1.}
}
\value{
This method returns a data.frame containing: ENSEMBL Peptide ID,
its position on the ordering,
node degree, number of triangles and clustering coefficient, and window
connectivity,
clustering coefficient and modularity.
}
\description{
Calculates protein (node) properties, such as: degree/connectivity,
number of triangles and
clustering coefficient; and properties of the window, region of n
(radius * 2 + 1) proteins
centered at a protein, such as: connectivity, clustering coefficient
and modularity.
}
\details{
Connectivity/degree of a node is the number of edges it presents.
A triangle of a node represents a
pair of connected neighbors, the number of triangles on the adjacency
list of a node is required to
calculate its clustering coefficient. The clustering coefficient of a
node measures, in the interval [0, 1],
the likelihood that any two of its neighbors are themselves connected,
this is calculated by the ratio
between the number of triangles that the node has, and the maximum
possible number of edges on its cluster
(nodeTriangles / (nodeDegree * (nodeDegree - 1) / 2)). The window
connectivity is the average connectivity
calculated over the window. The window clustering coefficient, a value
in the interval [0, 1],
is the average clustering coefficient calculated over the window.
The window modularity, a value in the
interval [0, 1], is defined as the ratio between the total number
of edges between any two nodes of the window,
and the sum of the degrees of the nodes presents in the window.
The window considers periodic boundary
conditions to deal with proteins near the ends of the ordering.
}
\examples{
transcriptogram <- transcriptogramPreprocess(association, Hs900, 2)
\dontrun{
oProperties <- orderingProperties(transcriptogram)
}

}
\references{
da Silva, S. R. M., Perrone, G. C., Dinis, J. M., and de Almeida, R. M. C. (2014). Reproducibility enhancement and differential expression of non predefined functional gene sets in human genome. BMC Genomics.

de Almeida, R. M. C., Clendenon, S. G., Richards, W. G., Boedigheimer, M., Damore, M., Rossetti, S., Harris, P. C., Herbert, B. S., Xu, W. M., Wandinger-Ness, A., Ward, H. H., Glazier, J. A. and Bacallao, R. L. (2016). Transcriptome analysis reveals manifold mechanisms of cyst development in ADPKD. Human Genomics, 10(1), 1–24.

Ferrareze, P. A. G., Streit, R. S. A., Santos, P. R. dos, Santos, F. M. dos, de Almeida, R. M. C., Schrank, A., Kmetzsch, L., Vainstein, M. H. and Staats, C. C. (2017). Transcriptional Analysis Allows Genome Reannotation and Reveals that Cryptococcus gattii VGII Undergoes Nutrient Restriction during Infection. Microorganisms.

Morais, D. A. A., Almeida, R. M. C. and Dalmolin, R. J. S. (2019). Transcriptogramer: an R/Bioconductor package for transcriptional analysis based on protein–protein interaction. Bioinformatics.

Rybarczyk-Filho, J. L., Castro, M. A. A., Dalmolin, R. J. S., Moreira, J. C. F., Brunnet, L. G., and de Almeida, R. M. C. (2011). Towards a genome-wide transcriptogram: the Saccharomyces cerevisiae case. Nucleic Acids Research, 39(8), 3005-3016.

Xavier, L. A. da C., Bezerra, J. F., de Rezende, A. A., Oliveira, R. A. de C., Dalmolin, R. J. S., do Amaral, V. S. (2017). Analysis of genome instability biomarkers in children with non-syndromic orofacial clefts. Mutagenesis, 32(2), 313–321.
}
\seealso{
\link[transcriptogramer]{transcriptogramPreprocess},
\link[transcriptogramer]{Hs900},
\link[transcriptogramer]{association}
}
\author{
Diego Morais
}
