#' Dataset containing expression values
#'
#' Expression values, obtained by microarray, of 3 cases and 3 controls
#' referring to the Gene Expression Omnibus accession number GSE9988.
#' The data.frame has 6 columns, each one contains expression values of a
#' sample, the first 3 columns are case samples, and the last 3 are control
#' samples. Each row contains expression values obtained by the probe mentioned
#' in its respective rowname. The expression values were normalized using the
#' \pkg{affy} package and, to reduce the required storage space,
#' this data.frame contains only 6 samples (GSM252443, GSM252444,
#' GSM252445, GSM252465, GSM252466, GSM252467). The rows of each sample
#' are composed only by probes mapped, by the GPL570 dictionary,
#' to proteins, from STRINGdb release 11,
#' of combined score greater than or equal to 900.
#'
#' @examples
#' GSE9988
#'
#' @seealso
#' \link[transcriptogramer]{GPL570}
#'
#' @author
#' Diego Morais
#'
#' @source \href{https://www.ncbi.nlm.nih.gov/geo/query/acc.cgi?acc=GSE9988}{GSE9988}

"GSE9988"

#' Dictionary Protein2Probe
#'
#' A mapping between ENSEMBL Peptide ID and probe identifier, for the Homo
#' sapiens
#' and the platform GPL570, [HG-U133_Plus_2] Affymetrix Human Genome U133
#' Plus 2.0 Array.
#'
#' @format Each row of the data.frame contains two variables:
#' \describe{
#'  \item{Protein}{The ENSEMBL Peptide ID}
#'  \item{Probe}{The probe identifier}
#' }
#'
#' @details
#' This dataset was created to map the Homo sapiens proteins, from STRINGdb
#' release 11, of combined score greater than or equal to 700.
#'
#' @examples
#' GPL570
#'
#' @seealso
#' \link[transcriptogramer]{GSE9988}
#'
#' @author
#' Diego Morais

"GPL570"

#' Association
#'
#' A subset of the Homo sapiens protein network data from STRINGdb,
#' release 11. This subset
#' contains only associations of proteins of combined score greater than or
#' equal to 900.
#'
#' @format Each row of the data.frame contains two variables:
#' \describe{
#'  \item{V1}{The ENSEMBL Peptide ID of the first protein}
#'  \item{V2}{The ENSEMBL Peptide ID of the second protein}
#' }
#'
#' @examples
#' association
#'
#' @seealso
#' \link[transcriptogramer]{Hs900}
#'
#' @author
#' Diego Morais

"association"

#' Ordered Homo sapiens proteins of combined score greater than or equal to 700
#'
#' A character vector containing the Homo sapiens proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 700.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 1451645000.
#'
#' @examples
#' Hs700
#'
#' @author
#' Diego Morais

"Hs700"

#' Ordered Homo sapiens proteins of combined score greater than or equal to 800
#'
#' A character vector containing the Homo sapiens proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 800.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 808731532.
#'
#' @examples
#' Hs800
#'
#' @author
#' Diego Morais

"Hs800"

#' Ordered Homo sapiens proteins of combined score greater than or equal to 900
#'
#' A character vector containing the Homo sapiens proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 900.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 489730786.
#'
#' @examples
#' Hs900
#'
#' @author
#' Diego Morais

"Hs900"

#' Ordered Rattus norvegicus proteins of combined score greater than or equal
#' to 700
#'
#' A character vector containing the Rattus norvegicus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 700.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 920071574.
#'
#' @examples
#' Rn700
#'
#' @author
#' Diego Morais

"Rn700"

#' Ordered Rattus norvegicus proteins of combined score greater than or equal
#' to 800
#'
#' A character vector containing the Rattus norvegicus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 800.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 453159596.
#'
#' @examples
#' Rn800
#'
#' @author
#' Diego Morais

"Rn800"

#' Ordered Rattus norvegicus proteins of combined score greater than or equal
#' to 900
#'
#' A character vector containing the Rattus norvegicus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 900.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 222438518.
#'
#' @examples
#' Rn900
#'
#' @author
#' Diego Morais

"Rn900"

#' Ordered Mus musculus proteins of combined score greater than or equal to 700
#'
#' A character vector containing the Mus musculus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 700.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 964301098.
#'
#' @examples
#' Mm700
#'
#' @author
#' Diego Morais

"Mm700"

#' Ordered Mus musculus proteins of combined score greater than or equal to 800
#'
#' A character vector containing the Mus musculus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 800.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 497514808.
#'
#' @examples
#' Mm800
#'
#' @author
#' Diego Morais

"Mm800"

#' Ordered Mus musculus proteins of combined score greater than or equal to 900
#'
#' A character vector containing the Mus musculus proteins, from STRINGdb
#' release 11,
#' of combined score greater than or equal to 900.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 282900384.
#'
#' @examples
#' Mm900
#'
#' @author
#' Diego Morais

"Mm900"

#' Ordered Saccharomyces cerevisiae proteins of combined score greater than or
#' equal to 700
#'
#' A character vector containing the Saccharomyces cerevisiae proteins, from
#' STRINGdb release 11,
#' of combined score greater than or equal to 700.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 163374428.
#'
#' @examples
#' Sc700
#'
#' @author
#' Diego Morais

"Sc700"

#' Ordered Saccharomyces cerevisiae proteins of combined score greater than or
#' equal to 800
#'
#' A character vector containing the Saccharomyces cerevisiae proteins, from
#' STRINGdb release 11,
#' of combined score greater than or equal to 800.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 85930192.
#'
#' @examples
#' Sc800
#'
#' @author
#' Diego Morais

"Sc800"

#' Ordered Saccharomyces cerevisiae proteins of combined score greater than or
#' equal to 900
#'
#' A character vector containing the Saccharomyces cerevisiae proteins, from
#' STRINGdb release 11,
#' of combined score greater than or equal to 900.
#'
#' @details Generated by The Transcriptogramer V.1.0 for Windows. Input
#' arguments: isothermal steps - 100; Monte Carlo steps - 20000;
#' cooling factor - 0.5; alpha value - 1.0;
#' percentual energy for initial temperature - 0.0001. Final energy:
#' 38447790.
#'
#' @examples
#' Sc900
#'
#' @author
#' Diego Morais

"Sc900"

#' Dictionary Protein2Symbol
#'
#' A mapping between ENSEMBL Peptide ID and Symbol (Gene Name).
#' This dataset was created to map the Homo sapiens proteins,
#' from STRINGdb release 11, of combined score greater than or equal to 900.
#'
#' @format Each row of the data.frame contains two variables:
#' \describe{
#'  \item{ensembl_peptide_id}{The ENSEMBL Peptide ID}
#'  \item{external_gene_name}{The Gene Name}
#' }
#'
#' @examples
#' DEsymbols
#'
#' @author
#' Diego Morais

"DEsymbols"

#' Dictionary Protein2GO
#'
#' A mapping between ENSEMBL Peptide ID and Gene Ontology, biological processes,
#' terms. This dataset was created to map the Homo sapiens proteins,
#' from STRINGdb release 11, of combined score greater than or equal to 900.
#'
#' @format Each row of the data.frame contains two variables:
#' \describe{
#'  \item{ensembl_peptide_id}{The ENSEMBL Peptide ID}
#'  \item{go_id}{The Gene Ontology ID}
#' }
#'
#' @examples
#' HsBPTerms
#'
#' @author
#' Diego Morais

"HsBPTerms"
