% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TranscriptionDataSet-class.R
\docType{class}
\name{TranscriptionDataSet-class}
\alias{TranscriptionDataSet-class}
\alias{TranscriptionDataSet}
\title{TranscriptionDataSet}
\description{
The \code{TranscriptionDataSet} is a S4 class to store input values,
intermediate calculations and results of the transcripts detection and
quantification analysis.
}
\section{Slots}{

\describe{
\item{\code{bamFile}}{\code{Character}. Path to a BAM file.}

\item{\code{fragments}}{\code{\link[GenomicRanges]{GRanges}}. Sequencing reads
extended to the fragment size.}

\item{\code{fragmentSize}}{\code{Numeric}. Fragment size in base pairs (bp).}

\item{\code{region}}{\code{\link[GenomicRanges]{GRanges}}. Genomic region(s) to
extract reads from.}

\item{\code{coveragePlus}}{\code{\link[IRanges]{RleList}}. Fragment coverage profile
for the forward DNA strand.}

\item{\code{coverageMinus}}{\code{\link[IRanges]{RleList}}. Fragment coverage profile
for the reverse DNA strand.}

\item{\code{coverageCutoff}}{\code{Numeric}. Background coverage cutoff value.}

\item{\code{coverageCutoffFdr}}{\code{Numeric}. False Discovery Rate (FDR) used to
estimate background coverage cutoff.}

\item{\code{gapDistanceTest}}{\code{Data.Frame}. Tested gap distances and
corresponding error rates.}

\item{\code{gapDistanceTestCovCutoff}}{\code{Numeric}. Coverage cutoff value used for
the gap distance estimation.}

\item{\code{transcripts}}{\code{\link[GenomicRanges]{GRanges}}. Identified transcripts.}

\item{\code{transcriptsCovCutoff}}{\code{Numeric}. Coverage cutoff value used for the
transcripts detection.}

\item{\code{transcriptsGapDist}}{\code{Numeric}. Gap distance value used for the
transcripts detection.}

\item{\code{transcriptsNormalization}}{\code{Numeric}. Total number of reads used for
normalization when calculating FPKM.}
}}

\seealso{
\code{\link{constructTDS}}
}
\author{
Armen R. Karapetyan
}
