% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/startVsEndTest.R
\name{startVsEndTest}
\alias{startVsEndTest}
\alias{startVsEndTest,SingleCellExperiment-method}
\alias{startVsEndTest,list-method}
\title{Perform statistical test to check for DE between starting point and the end
stages of every lineage}
\usage{
startVsEndTest(models, ...)

\S4method{startVsEndTest}{SingleCellExperiment}(
  models,
  global = TRUE,
  lineages = FALSE,
  pseudotimeValues = NULL,
  l2fc = 0
)

\S4method{startVsEndTest}{list}(
  models,
  global = TRUE,
  lineages = FALSE,
  pseudotimeValues = NULL,
  l2fc = 0
)
}
\arguments{
\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}.}

\item{...}{parameters including:}

\item{global}{If TRUE, test for all lineages simultaneously.}

\item{lineages}{If TRUE, test for all lineages independently.}

\item{pseudotimeValues}{A vector of length 2, specifying two pseudotime
values to be compared against each other, for every lineage of
 the trajectory.
 @details Note that this test assumes that all lineages start at a
 pseudotime value of zero, which is the starting point against which the
 end point is compared.}

\item{l2fc}{The log2 fold change threshold to test against. Note, that
this will affect both the global test and the pairwise comparisons.}
}
\value{
A matrix with the wald statistic, the number of df and the p-value
 associated with each gene for all the tests performed. Also, for each possible
 pairwise comparision, the observed log fold changes. If the testing
 procedure was unsuccessful, the procedure will return NA test statistics,
 fold changes and p-values.
}
\description{
This function assesses differential expression between the
average expression of the start and end points of a lineage.
}
\examples{
data(gamList, package = "tradeSeq")
startVsEndTest(gamList, global = TRUE, lineages = TRUE)
}
