% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotSmoothers.R
\name{plotSmoothers}
\alias{plotSmoothers}
\alias{plotSmoothers,gam-method}
\alias{plotSmoothers,SingleCellExperiment-method}
\title{Plot the log-transformed counts and the fitted values for a particular
 gene along all lineages}
\usage{
plotSmoothers(models, ...)

\S4method{plotSmoothers}{gam}(
  models,
  nPoints = 100,
  lwd = 2,
  size = 2/3,
  xlab = "Pseudotime",
  ylab = "Log(expression + 1)",
  border = TRUE,
  alpha = 1,
  sample = 1
)

\S4method{plotSmoothers}{SingleCellExperiment}(
  models,
  counts,
  gene,
  nPoints = 100,
  lwd = 2,
  size = 2/3,
  xlab = "Pseudotime",
  ylab = "Log(expression + 1)",
  border = TRUE,
  alpha = 1,
  sample = 1,
  pointCol = NULL,
  curvesCols = NULL,
  plotLineages = TRUE,
  lineagesToPlot = NULL
)
}
\arguments{
\item{models}{Either the \code{SingleCellExperiment} object obtained after
running \code{fitGAM}, or the specific GAM model for the corresponding gene,
if working with the list output of \code{tradeSeq}.}

\item{...}{parameters including:}

\item{nPoints}{The number of points used to extrapolate the fit.
Defaults to 100.}

\item{lwd}{Line width of the smoother. Passed to \code{\link{geom_line}}.}

\item{size}{Character expansion of the data points. Passed to \code{\link{geom_point}}.}

\item{xlab}{x-axis label. Passed to \code{\link{labs}}.}

\item{ylab}{y-axis label. Passed to \code{\link{labs}}.}

\item{border}{Logical: should a white border be drawn around the mean smoother.}

\item{alpha}{Numeric between 0 and 1, determines the transparency of data points,
see \code{scale_color_viridis_d}.}

\item{sample}{Numeric between 0 and 1, use to subsample the cells when there
are too many so that it can plot faster.}

\item{counts}{The matrix of gene expression counts.}

\item{gene}{Gene name or row in count matrix of gene to plot.}

\item{pointCol}{Plotting colors for each cell. Can be either character vector of
length 1, denoting a variable in the \code{colData(models)} to color cells by,
or a vector of length equal to the number of cells.}

\item{curvesCols}{Plotting colors for each curve Should be a list of colors
of the exact same length as the number of curves, i.e. the number of lineages
(if there is no conditions) or the number of lineages by the number of conditions.
In the second case, the colors are grouped by condition (lineage 1 - condition 1, 
lineage 1 - condition 2,...).}

\item{plotLineages}{Logical, should the mean smoothers for each lineage
be plotted?}

\item{lineagesToPlot}{A vector of integers referring to the lineages to be plotted.}
}
\value{
A \code{\link{ggplot}} object
}
\description{
Plot the smoothers estimated by \code{tradeSeq}.
}
\examples{
set.seed(8)
data(crv, package="tradeSeq")
data(countMatrix, package="tradeSeq")
counts <- as.matrix(countMatrix)
sce <- fitGAM(counts = counts,
                  sds = crv,
                  nknots = 5)
plotSmoothers(sce, counts, rownames(counts)[1])
# Show only first lineage curve
curvesCols <- c("#440154FF", "transparent")
plotSmoothers(sce, counts, rownames(counts)[1], curvesCols = curvesCols,
  border = FALSE)
# Show only first curve and cells assigned to first lineage
plotSmoothers(sce, counts, rownames(counts)[1], curvesCols = curvesCols,
  border = FALSE) +
  ggplot2::scale_color_manual(values = curvesCols)
}
