% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIoperator.R
\name{GIoperator}
\alias{GIoperator}
\title{GInteractions operator}
\usage{
GIoperator(gi_list, col = "score", operator = c("+", "-", "*", "/"))
}
\arguments{
\item{gi_list}{a list of GInteractions objects}

\item{col}{colname of metadata to be calculated}

\item{operator}{operator, "+" means A + B, and so on. 
User-defined function also could be used.}
}
\value{
an object of GInteractions
}
\description{
GInteractions operations (add, aubtract, multiply, divide)
}
\examples{
library(InteractionSet)
gr2 <- GRanges(seqnames=c("chr1", "chr1"),
               ranges=IRanges(c(7,13), width=3))
gr3 <- GRanges(seqnames=c("chr1", "chr1"),
               ranges=IRanges(c(1, 4), c(3, 9)))
gi <- GInteractions(gr2, gr3, score=c(1, 2))
gi2 <- GInteractions(gr2, gr3, score=c(3, 4))
GIoperator(list(gi, gi2), col="score", operator="+")
GIoperator(list(gi, gi2), col="score", operator="-")
}
