% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARA.R
\name{ARA}
\alias{ARA}
\title{Aggregate Region Analysis}
\usage{
ARA(gr, upstream = 2e+05, downstream = upstream, resolution = 10000, ...)
}
\arguments{
\item{gr}{A `GRanges` object. The center of the object will be used for
alignment for all the given regions.}

\item{upstream, downstream}{numeric(1L). Upstream and downstream from the 
center of given `gr` input will be used to extract the signals.}

\item{resolution}{numeric(1L). The resolution will be passed to
\link{importGInteractions} function.}

\item{...}{The parameters used by \link{importGInteractions} function.
Please note that the ranges resolution and out parameter should not be
involved.}
}
\value{
A \link[InteractionSet:GInteractions-class]{GInteractions} object
with scores which represent the mean values of the interactions.
}
\description{
Extract the interaction signal means from given coordinates.
}
\examples{
hic <- system.file("extdata", "test_chr22.hic", package = "trackViewer",
                   mustWork=TRUE)
gr <- GRanges("22", c(seq(20000001, 50000001, by=10000000), width=1))
gi <- ARA(gr, file=hic, format="hic")
rg <- GRanges("22", IRanges(1, 400000))
op <- optimizeStyle(trackList(gi2track(gi)))
heatmap <- op$tracks
sty <- op$style
setTrackViewerStyleParam(sty, "xat", c(1, 200000, 400000))
setTrackViewerStyleParam(sty, "xlabel",c("-20K", "center", "20K"))
viewTracks(heatmap, viewerStyle=sty, gr=rg)
}
