% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-NCBSet.R
\docType{class}
\name{NCBSet-class}
\alias{NCBSet-class}
\alias{bestConditions,NCBSet-method}
\alias{bestConditions}
\alias{fragmentationMap,NCBSet-method}
\alias{fragmentationMap}
\alias{show,NCBSet-method}
\alias{summary,NCBSet-method}
\title{The NCBSet class}
\usage{
\S4method{bestConditions}{NCBSet}(
  object,
  n = ncol(object),
  minN = 0L,
  maximise = c("fragments", "bonds"),
  ...
)

\S4method{fragmentationMap}{NCBSet}(
  object,
  nCombinations = 10,
  cumCoverage = TRUE,
  maximise = c("fragments", "bonds"),
  labels = colnames(object),
  alphaIntensity = TRUE,
  ...
)

\S4method{show}{NCBSet}(object)

\S4method{summary}{NCBSet}(object, what = c("conditions", "bonds"), ...)
}
\arguments{
\item{object}{\code{NCBSet}}

\item{n}{\code{integer}, max number of combinations/iterations.}

\item{minN}{\code{integer},
stop if there are less than \code{minN} additional fragments}

\item{maximise}{\code{character}, optimisation targeting for the highest number of
\code{"fragments"} (default) or \code{"bonds"}.}

\item{nCombinations}{\code{integer},
number of combinations to show (0 to avoid plotting them at all).}

\item{cumCoverage}{\code{logical},
if \code{TRUE} (default) cumulative coverage of combinations is shown.}

\item{labels}{\code{character}, overwrite x-axis labels.}

\item{alphaIntensity}{\code{logical}, if \code{TRUE} (default) the alpha level of the
color is used to show the \code{colData(object)$AssignedIntensity}. If \code{FALSE} the
alpha is set to \code{1}.}

\item{what}{\code{character},
specifies whether \code{"conditions"} (columns; default) or
\code{"bonds"} (rows) should be summarized.}

\item{\ldots}{arguments passed to internal/other methods.
added.}
}
\value{
An \linkS4class{NCBSet} object.
}
\description{
The NCBSet class is a container for a top-down proteomics experiment
similar to the \linkS4class{TopDownSet}
but instead of intensity values it just stores the information if a
bond is covered by a N-terminal (encoded as \code{1}),
a C-terminal (encoded as \code{2})
and/or bidirectional fragments (encoded as \code{3}).
}
\section{Methods (by generic)}{
\itemize{
\item \code{bestConditions(NCBSet)}: Best combination of conditions.

Finds the best combination of conditions for highest coverage of fragments or
bonds. If there are two (or more conditions) that would add the same number
of fragments/bonds the one with the highest assigned intensity is used. Use
\code{n} to limit the number of iterations and combinations that should be
returned.
If \code{minN} is set at least \code{minN} fragments have to be added to the
combinations. The function returns a 7-column matrix. The first column
contains the index (\code{Index}) of the condition (column number). The next
columns contain the newly added number of fragments or bonds
(\code{FragmentsAddedToCombination}, \code{BondsAddedToCombination}), the fragments
or bonds in the condition (\code{FragmentsInCondition}, \code{BondsInCondition}), and
the cumulative coverage fragments or bonds (\code{FragmentCoverage},
\code{BondCoverage}).

\item \code{fragmentationMap(NCBSet)}: Plot fragmentation map.

Plots a fragmentation map of the Protein.
Use \code{nCombinations} to add another
plot with \code{nCombinations} combined conditions.
If \code{cumCoverage} is \code{TRUE} (default)
these combinations increase the coverage cumulatively.

\item \code{summary(NCBSet)}: Summary statistics.

Returns a \code{matrix} with some statistics: number of fragments,
total/min/first quartile/median/mean/third quartile/maximum of intensity
values.

}}
\section{Slots}{

\describe{
\item{\code{rowViews}}{\link[Biostrings:XStringViews-class]{Biostrings::XStringViews},
information about bonds (name, start, end, width, sequence),
see \link[Biostrings:XStringViews-class]{Biostrings::XStringViews} for details.}

\item{\code{colData}}{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame},
information about the MS2 experiments and the fragmentation conditions.}

\item{\code{assay}}{\link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix},
coverage values of the bonds. The rows correspond to the bonds and the
columns to the condition/run. It just stores values that are different
from zero. If a bond is covered by an N-terminal fragment its encoded
with \code{1}, by an C-terminal fragmentl with \code{2} and
by both fragment types/bidirectional by \code{3} respectively.}

\item{\code{files}}{\code{character}, files that were imported.}

\item{\code{processing}}{\code{character}, log messages.}
}}

\examples{
## Example data
data(tds, package="topdownr")

## Aggregate technical replicates
tds <- aggregate(tds)

## Coercion into an NCBSet object
ncb <- as(tds, "NCBSet")

ncb

head(summary(ncb))

# Accessing slots
rowViews(ncb)
colData(ncb)
head(assayData(ncb))

# Accessing colData
ncb$Mz

# Subsetting

# First 100 bonds
ncb[1:100]

# Just bond 152
ncb["bond152"]

# Condition 1 to 10
ncb[, 1:10]

# Plot fragmentation map
fragmentationMap(ncb)
}
\seealso{
\itemize{
\item An \code{NCBSet} is generated from an \linkS4class{TopDownSet} object.
\item \link[Biostrings:XStringViews-class]{Biostrings::XStringViews}
for the row view interface.
\item \link[Matrix:dgCMatrix-class]{Matrix::dgCMatrix}
for technical details about the coverage storage.
}
}
\author{
Sebastian Gibb \email{mail@sebastiangibb.de}
}
