% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topconfects.R
\name{rank_rank_plot}
\alias{rank_rank_plot}
\title{A plot to compare two rankings}
\usage{
rank_rank_plot(
  vec1,
  vec2,
  label1 = "First ranking",
  label2 = "Second ranking",
  n = 40
)
}
\arguments{
\item{vec1}{A vector of names.}

\item{vec2}{Another vector of names.}

\item{label1}{A label to go along with vec1.}

\item{label2}{A label to go along with vec2.}

\item{n}{Show at most the first n names in vec1 and vec2.}
}
\value{
A ggplot2 object. Working non-interactively, you must print() this for it to
be displayed.
}
\description{
This is useful, for example, when comparing different methods of ranking
potentially interesting differentially expressed genes.
}
\examples{

a <- sample(letters)
b <- sample(letters)
rank_rank_plot(a,b, n=20)

}
