% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object.R
\name{tomoMatrix}
\alias{tomoMatrix}
\title{Create an object from matrix}
\usage{
tomoMatrix(
  matrix.count = NULL,
  matrix.normalized = NULL,
  min.section = 3,
  normalize = TRUE,
  normalize.method = "median",
  scale = TRUE
)
}
\arguments{
\item{matrix.count}{A numeric matrix or matrix-like data stucture that can be coverted to matrix, with genes with rows, sections as columns and values as raw read counts. Columns should be sorted according to section numbers.}

\item{matrix.normalized}{A numeric matrix or matrix-like data stucture that can be coverted to matrix, with genes as rows, sections as columns and values as normalized read counts. Columns should be sorted according to order of sections.}

\item{min.section}{Integer. Genes expressed in less than \code{min.section} sections will be filtered out.}

\item{normalize}{Logical, whether to perform normalization when creating the object. Default is TRUE.}

\item{normalize.method}{Character, must be one of \code{"median"}, or \code{"cpm"}.}

\item{scale}{Logical, whether to perform scaling when creating the object. Default is TRUE.}
}
\value{
A \code{SummarizedExperiment} object
}
\description{
\code{tomoMatrix} creates an object from raw read count matrix or normalized read count matrix.
}
\examples{
data(zh.data)
zh <- tomoMatrix(zh.data)

}
\seealso{
\code{\link{createTomo}} for the generic function.
}
