% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{embedPlot}
\alias{embedPlot}
\title{Embedding plot for sections}
\usage{
embedPlot(object, group = "section", method = "TSNE")
}
\arguments{
\item{object}{A \code{SummarizedExperiment} object.}

\item{group}{Character, a variable in slot \code{meta} defining the groups of sections. Sections in the same group have same colors.}

\item{method}{Character, the embeddings for scatter plot. Must be one of \code{"TSNE"}, \code{"UMAP"}, or \code{"PCA"}.}
}
\value{
A \code{ggplot} object.
}
\description{
Scatter plot for sections with two-dimenstional embeddings in a \code{SummarizedExperiment} object. Each point stands for a section.
}
\examples{
data(zh.data)
zh <- createTomo(zh.data)
zh <- runTSNE(zh)
# Plot TSNE embeddings.
embedPlot(zh)

# Plot UMAP embeddings.
zh <- runUMAP(zh)
embedPlot(zh, method="UMAP")

# Color sections by kmeans cluster labels.
zh <- kmeansClust(zh, 3)
embedPlot(zh, group="kmeans_cluster")
}
