% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUpDownCluster.R
\name{getUpDownCluster}
\alias{getUpDownCluster}
\title{Up-Down clustering}
\usage{
getUpDownCluster(X, diff_threshold = 0)
}
\arguments{
\item{X}{a dataframe or list of dataframe with the same number of rows.}

\item{diff_threshold}{a number (optional, default 0), if the difference between 2 values is lower than the threshold, the returned sign will be 0 (no variation).}
}
\description{
Performs a clustering based on the signs of variation between 2 timepoints.
Optionally, if the difference between 2 timepoints is lower than a given threshold, 
the returned difference will be 0.
}
\examples{
demo <- suppressWarnings(get_demo_cluster())
X <- list(X = demo$X, Y = demo$Y, Z = demo$Z)
res <- getUpDownCluster(X)
class(res)
getCluster(res)

X <- demo$X
res <- getUpDownCluster(X)
res <- getUpDownCluster(X, diff_threshold = 15)
res_cluster <- getCluster(res)
}
