% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCluster.R
\name{getCluster}
\alias{getCluster}
\title{Get variable cluster from (s)PCA, (s)PLS or block.(s)PLS}
\usage{
getCluster(X, user.block = NULL, user.cluster = NULL)
}
\arguments{
\item{X}{an object of the class: \code{pca}, \code{spca}, \code{pls}, \code{spls}, \code{block.pls} or \code{block.spls}}

\item{user.block}{a vector to filter the result and return the features of the specified blocks.}

\item{user.cluster}{a vector to filter the result and return only the features of the specified clusters}
}
\value{
A data.frame containing the name of feature, its assigned cluster and other information such as selected component, contribution, sign, ...
}
\description{
This function returns the cluster associated to each feature from a mixOmics object.
}
\details{
For each feature, the cluster is assigned according to the maximum contribution on a component and the sign of that contribution.
}
\examples{
demo <- suppressWarnings(get_demo_cluster())
pca.cluster <- getCluster(demo$pca)
spca.cluster <- getCluster(demo$spca)
pls.cluster <- getCluster(demo$pls)
spls.cluster <- getCluster(demo$spls)
block.pls.cluster <- getCluster(demo$block.pls)
block.spls.cluster <- getCluster(demo$block.spls)

}
\seealso{
\code{\link[mixOmics]{selectVar}}
}
