% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keep_variable.R
\docType{methods}
\name{keep_variable}
\alias{keep_variable}
\alias{keep_variable,SummarizedExperiment-method}
\alias{keep_variable,RangedSummarizedExperiment-method}
\title{Keep variable transcripts}
\usage{
keep_variable(
  .data,
  .abundance = NULL,
  top = 500,
  transform = log1p,
  log_transform = TRUE
)

\S4method{keep_variable}{SummarizedExperiment}(.data, top = 500, transform = log1p)

\S4method{keep_variable}{RangedSummarizedExperiment}(.data, top = 500, transform = log1p)
}
\arguments{
\item{.data}{A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment))}

\item{.abundance}{The name of the transcript/gene abundance column}

\item{top}{Integer. Number of top transcript to consider}

\item{transform}{A function that will tranform the counts, by default it is log1p for RNA sequencing data, but for avoinding tranformation you can use identity}

\item{log_transform}{DEPRECATED. Use transform instead.}
}
\value{
A consistent object (to the input) with additional columns for the statistics from the hypothesis test (e.g.,  log fold change, p-value and false discovery rate).

Underlying method:
	s <- rowMeans((x - rowMeans(x)) ^ 2)
o <- order(s, decreasing = TRUE)
x <- x[o[1L:top], , drop = FALSE]
variable_trancripts = rownames(x)

A `SummarizedExperiment` object

A `SummarizedExperiment` object
}
\description{
keep_variable() takes as input A `tbl` (with at least three columns for sample, feature and transcript abundance) or `SummarizedExperiment` (more convenient if abstracted to tibble with library(tidySummarizedExperiment)) and returns a consistent object (to the input) with additional columns for the statistics from the hypothesis test.
}
\details{
`r lifecycle::badge("maturing")`

At the moment this function uses edgeR \url{https://doi.org/10.1093/bioinformatics/btp616}
}
\examples{
## Load airway dataset for examples

  data('airway', package = 'airway')
  # Ensure a 'condition' column exists for examples expecting it

    SummarizedExperiment::colData(airway)$condition <- SummarizedExperiment::colData(airway)$dex





	keep_variable(airway, top = 500)

}
\references{
Mangiola, S., Molania, R., Dong, R., Doyle, M. A., & Papenfuss, A. T. (2021). tidybulk: an R tidy framework for modular transcriptomic data analysis. Genome Biology, 22(1), 42. doi:10.1186/s13059-020-02233-7
}
