% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terapadog.R
\name{terapadog}
\alias{terapadog}
\title{Performs the main Gene Set Enrichement Analysis, by applying a modified
version of the PADOG algorithm to genes undergoing changes in TE.}
\usage{
terapadog(
  esetm = NULL,
  exp_de = NULL,
  paired = FALSE,
  gslist = "KEGGRESTpathway",
  organism = "hsa",
  gs.names = NULL,
  NI = 1000,
  Nmin = 3,
  verbose = TRUE
)
}
\arguments{
\item{esetm}{A matrix containing the counts from RNA and RIBO samples.
Rownames must be ensembl GENEIDs, while column names must be sample names.
Refer to prepareTerapadogData.R to prepare input data.}

\item{exp_de}{A dataframe containing information regarding the samples.
It has number of rows equal to the columns of esetm.
It has a formatted vocabulary, but can be obtained by running
prepareTerapadogData.R.}

\item{paired}{Logical. Specify is the study has a paired design or not.
If it does, be sure that the pairs are specified in the "Block" column of the
exp_de dataframe.}

\item{gslist}{A list of named character vectors. Each vector is named after a
KEGG pathway ID and each element within the vector is an ENSEMBL gene ID for
a gene part of said pathway.}

\item{organism}{A three letter string giving the name of the organism
supported by the "KEGGREST" package.}

\item{gs.names}{Character vector with the names of the gene sets.
If specified, must have the same length as gslist.}

\item{NI}{Number of iterations allowed to determine the gene set score
significance p-values.}

\item{Nmin}{The minimum size of gene sets to be included in the analysis.}

\item{verbose}{Logical. If true, shows number of iterations done.}
}
\value{
A dataframe with the PADOG score for each pathway in exam.
}
\description{
Performs the main Gene Set Enrichement Analysis, by applying a modified
version of the PADOG algorithm to genes undergoing changes in TE.
}
