% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{associated_peaks}
\alias{associated_peaks}
\title{Predict associated peaks}
\usage{
associated_peaks(peaks, regions, regions_col, base = 1e+05)
}
\arguments{
\item{peaks}{A GRanges object}

\item{regions}{A GRanges object}

\item{regions_col}{A character string}

\item{base}{An integer to calculate distances relative to.}
}
\value{
A GRanges object. A similar object to peaks with three added
metadata columns.
}
\description{
This function selects overlapping peaks and regions, calculates the distance
between them and score each peak.
}
\examples{
# load peaks and transcripts data
data("real_peaks")
data("real_transcripts")

# associated peaks
ap <- associated_peaks(real_peaks, real_transcripts, 'name2')

}
