% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotChrDar.R
\name{plotChrDar}
\alias{plotChrDar}
\alias{plotChrDar,GRanges-method}
\title{Plot DAR across a chromosome}
\usage{
plotChrDar(
  dar,
  dar_val = c("origin", "region"),
  chr,
  foi,
  foi_anno,
  foi_highlight = TRUE,
  features,
  features_anno,
  features_highlight = TRUE,
  title = ""
)

\S4method{plotChrDar}{GRanges}(
  dar,
  dar_val = c("origin", "region"),
  chr,
  foi,
  foi_anno,
  foi_highlight = TRUE,
  features,
  features_anno,
  features_highlight = TRUE,
  title = ""
)
}
\arguments{
\item{dar}{\code{GRanges} with DAR values of associated ranges contained
in metadata columns.
Used to build the DataTrack showing the trend in DAR across the chromosome.
If ranges of the input object span regions (i.e. post application of
\code{\link[=flipRanges]{flipRanges()}}), data points are plotted at the midpoint of the region.}

\item{dar_val}{\code{character(1)} specifying the whether to use origin or region
DAR values for the chosen ranges.
Options are "origin" and "region".
The default ("region") represents averaged DAR values across a region and
produces a smoother graph.}

\item{chr}{Optional.
\code{character(1)} specifying the chromosome to subset all \code{GRanges} objects.
Plotting is only possible across a single chromosome and  is therefore
required if supplying \code{GRanges} objects spanning multiple chromosomes.
Also controls the track title for the GenomeAxisTrack.}

\item{foi}{Optional.
\code{GRanges} object of features of interest (foi) to be highlighted and labelled
along the GenomeAxisTrack.}

\item{foi_anno}{Optional.
\code{character(1)} specifying the name of the \code{mcol} containing labels
associated with feature ranges in \code{foi}.}

\item{foi_highlight}{\code{logical(1)} specifying if the positions of \code{foi}
should be overlayed on the DataTrack showing the trend in DAR.
Useful for visually inspecting DAR at the location of chosen features.
Default is \code{TRUE}.}

\item{features}{Optional.
\code{GRanges} object of features to be plotted on a separate AnnotationTrack.}

\item{features_anno}{Optional.
\code{character(1)} specifying the name of the \code{mcol} containing labels
associated with feature ranges in \code{features}.}

\item{features_highlight}{\code{logical(1)} specifying if the positions of
\code{features} should be overlayed on the DataTrack showing the trend in DAR.
Useful for visually inspecting DAR at the location of chosen features.
Default is \code{TRUE}.}

\item{title}{\code{character(1)}.
The main plot title.}
}
\value{
A Gviz object
}
\description{
Use \code{Gviz} to plot the trend in DAR across a chromosomal region
with the option to add features of interest as separate tracks.
}
\examples{
set.seed(230822)
data("chr1_genes")
foi <- sample(chr1_genes, 1)
features <- sample(chr1_genes, 20)
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
counts <- countAlleles(genotypes, groups)
counts_filt <- filterLoci(counts)
props <- countsToProps(counts_filt)
contrasts <- matrix(
    data = c(1, -1),
    dimnames = list(
        Levels = c("group1", "group2"),
        Contrasts = c("group1v2")
    )
)
dar <- dar(props, contrasts, region_loci = 5)
plotChrDar(
    dar = dar$group1v2, dar_val = "region", chr = "1",
    foi = foi, foi_anno = "gene_name", foi_highlight = TRUE,
    features = features, features_anno = "gene_name",
    features_highlight = TRUE,
    title = "Example plot of DAR along Chromosome 1"
)

}
