% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/countAlleles.R
\name{countAlleles}
\alias{countAlleles}
\alias{countAlleles,GRanges,list-method}
\title{Count alleles within each experimental group}
\usage{
countAlleles(genotypes, groups)

\S4method{countAlleles}{GRanges,list}(genotypes, groups)
}
\arguments{
\item{genotypes}{\code{GRanges} object with metadata columns containing genotype
information for all samples.}

\item{groups}{Named \code{list} specifying the sample grouping structure, where
each element contains a character vector of sample names.}
}
\value{
\code{GRangesList} containing a summary of allele counts at each range.
Each element of the list represents a distinct sample group.
}
\description{
Summarise the alleles from genotype calls at each single
nucleotide locus within each sample group.
}
\examples{
fl <- system.file("extdata", "chr1.vcf.bgz", package="tadar")
genotypes <- readGenotypes(fl)
groups <- list(
    group1 = paste0("sample", 1:6),
    group2 = paste0("sample", 7:13)
)
countAlleles(genotypes, groups)

}
