% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsCore.R
\name{spsTabInfo}
\alias{spsTabInfo}
\title{View SPS project 'config/tabs.csv' information}
\usage{
spsTabInfo(return_type = "print", n_print = 40, app_path = getwd())
}
\arguments{
\item{return_type}{one of 'print', 'data', 'colnames', or a specified column
name}

\item{n_print}{how many lines of tab info you want to print out}

\item{app_path}{SPS project root}
}
\value{
return depends on \code{return_type}
}
\description{
View SPS project 'config/tabs.csv' information
}
\details{
\itemize{
\item 'print' will print out the entire \emph{tabs.csv}, you can
specify \code{n_print} for how many lines you want to print;
\item 'data' will return the tab info tibble
\item 'colnames' will return all column names of tab info file
\item A column name will extract the specified column out and return as a vector
}
}
\examples{
spsInit(project_name = "SPS_tabinfo", overwrite = TRUE,
        change_wd = FALSE, open_files = FALSE)
# all lines
spsTabInfo("print", app_path = "SPS_tabinfo")
# 5 lines
spsTabInfo("print", app_path = "SPS_tabinfo", n_print = 5L)
spsTabInfo("data", app_path = "SPS_tabinfo")
spsTabInfo("colnames", app_path = "SPS_tabinfo")
spsTabInfo("tab_id", app_path = "SPS_tabinfo")
}
