% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_microsynteny-based_phylogeny.R
\name{profiles2phylip}
\alias{profiles2phylip}
\title{Save the transposed binary profiles matrix to a file in PHYLIP format}
\usage{
profiles2phylip(transposed_profiles = NULL, outdir = tempdir())
}
\arguments{
\item{transposed_profiles}{A binary and transposed profile matrix.
The profile matrix can be obtained with \code{phylogenomic_profile()}.}

\item{outdir}{Path to output directory. By default, files are saved in
a temporary directory, so they will be deleted when the R session closes.
If you want to keep the files, specify a custom output directory.}
}
\value{
Character specifying the path to the PHYLIP file.
}
\description{
Save the transposed binary profiles matrix to a file in PHYLIP format
}
\examples{
data(clusters)
profile_matrix <- phylogenomic_profile(clusters)
tmat <- binarize_and_transpose(profile_matrix)
profiles2phylip(tmat)
}
