% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_synteny.R
\name{interspecies_synteny}
\alias{interspecies_synteny}
\title{Detect interspecies synteny}
\usage{
interspecies_synteny(
  blast_inter = NULL,
  annotation = NULL,
  inter_dir = file.path(tempdir(), "inter"),
  anchors = 5,
  max_gaps = 25,
  is_pairwise = TRUE,
  verbose = FALSE,
  bp_param = BiocParallel::SerialParam(),
  ...
)
}
\arguments{
\item{blast_inter}{A list of BLAST/DIAMOND data frames for
interspecies comparisons as returned by \code{run_diamond()}.}

\item{annotation}{A processed GRangesList or CompressedGRangesList object
as returned by \code{process_input()}.}

\item{inter_dir}{Path to output directory where .collinearity files will
be stored.}

\item{anchors}{Numeric indicating the minimum required number of genes
to call a syntenic block. Default: 5.}

\item{max_gaps}{Numeric indicating the number of upstream and downstream
genes to search for anchors. Default: 25.}

\item{is_pairwise}{specify if only pairwise blocks should be reported
Default: TRUE.}

\item{verbose}{Logical indicating if log messages should be printed on
screen. Default: FALSE.}

\item{bp_param}{BiocParallel back-end to be used.
Default: \code{BiocParallel::SerialParam()}.}

\item{...}{Any additional arguments to the \code{MCScanX} algorithm. For a
complete list of all available options, see the man page
of \code{rcpp_mcscanx_file()}.}
}
\value{
Paths to .collinearity files.
}
\description{
Detect interspecies synteny
}
\examples{
# Load data
data(proteomes)
data(blast_list)
data(annotation)

# Get DIAMOND and processed annotation lists
blast_inter <- blast_list[2]
annotation <- process_input(proteomes, annotation)$annotation

# Detect interspecies synteny
intersyn <- interspecies_synteny(blast_inter, annotation)
}
