% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_dose_response_model.R
\name{PredictResponse}
\alias{PredictResponse}
\title{Predict Response Value at Certain Drug Dose}
\usage{
PredictResponse(df, dose)
}
\arguments{
\item{df}{A data frame. It contains two variable:
\itemize{
  \item \strong{dose} a serial of concentration of drug;
  \item \strong{response} the cell line response to each concentration of
  drug. It should be the inhibition rate according to negative control.
}}

\item{dose}{A numeric vector. It specifies the dose at which user want to
predict the response of cell line to the drug.}
}
\value{
A numeric vector. It is the response values of cell line to the drug
 at inputted dose.
}
\description{
\code{PredictResponse} uses \code{\link[drc]{drm}} function to fit the dose
response model and generate the predict response value at the given dose.
}
\details{
\strong{Note}: Random number generator used in \code{AddNoise} with
\code{method = "random"}. If the analysis requires for reproductiblity,
plesase set the random seed before calling this function.
}
\author{
\itemize{
  \item Shuyu Zheng \email{shuyu.zheng@helsinki.fi}
  \item Jing Tang \email{jing.tang@helsinki.fi}
}
}
