% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLSDA_charts.R
\name{pls_scores_plot}
\alias{pls_scores_plot}
\alias{pls_scores_plot,}
\alias{plsda_scores_plot}
\title{PLSDA scores plot}
\usage{
pls_scores_plot(
  xcol = "LV1",
  ycol = "LV2",
  points_to_label = "none",
  factor_name,
  ellipse = "all",
  ellipse_type = "norm",
  ellipse_confidence = 0.95,
  label_filter = character(0),
  label_factor = "rownames",
  label_size = 3.88,
  components = NULL,
  ...
)

plsda_scores_plot(
  xcol = "LV1",
  ycol = "LV2",
  points_to_label = "none",
  factor_name,
  ellipse = "all",
  ellipse_type = "norm",
  ellipse_confidence = 0.95,
  label_filter = character(0),
  label_factor = "rownames",
  label_size = 3.88,
  components = NULL,
  ...
)
}
\arguments{
\item{xcol}{(numeric, integer, character) The column name, or index, of data to plot on the x-axis. The default is \code{"LV1"}.}

\item{ycol}{(numeric, integer, character) The column name, or index, of data to plot on the y-axis. The default is \code{"LV2"}.}

\item{points_to_label}{(character) Points to label. Allowed values are limited to the following: \itemize{ \item{\code{"none"}: No samples labels are displayed.}\item{\code{"all"}: The labels for all samples are displayed.}\item{\code{"outliers"}: Labels for for potential outlier samples are displayed.}} The default is \code{"none"}.}

\item{factor_name}{(character) The name of a sample-meta column to use.}

\item{ellipse}{(character) Plot ellipses. Allowed values are limited to the following: \itemize{ \item{\code{"all"}: Ellipses are plotted for all groups and all samples.}\item{\code{"group"}: Ellipses are plotted for all groups.}\item{\code{"none"}: Ellipses are not included on the plot.}\item{\code{"sample"}: An ellipse is plotted for all samples (ignoring group).}} The default is \code{"all"}.}

\item{ellipse_type}{(character) Type of ellipse. Allowed values are limited to the following: \itemize{ \item{\code{"norm"}: Multivariate normal (p = 0.95).}\item{\code{"t"}: Multivariate t (p = 0.95).}} The default is \code{"norm"}.}

\item{ellipse_confidence}{(numeric) The confidence level for plotting ellipses. The default is \code{0.95}.\cr}

\item{label_filter}{(character) Labels are only plotted for the named groups. If zero-length then all groups are included. The default is \code{character(0)}.}

\item{label_factor}{(character) The column name of sample_meta to use for labelling samples on the plot. "rownames" will use the row names from sample_meta. The default is \code{"rownames"}.}

\item{label_size}{(numeric) The text size of labels. Note this is not in Font Units. The default is \code{3.88}.\cr}

\item{components}{(numeric, integer, NULL) The principal components used to generate the plot. If provided this parameter overrides xcol and ycol params. The default is \code{NULL}.}

\item{...}{Additional slots and values passed to \code{struct_class}.}
}
\value{
A  \code{
pls_scores_plot
} object. This object has no \code{output} slots.
See \code{\link[struct]{chart_plot}} in the \code{struct} package to plot this chart object.
}
\description{
A scatter plot of the selected PLSDA scores.
}
\section{Inheritance}{

A \code{pls_scores_plot} object inherits the following \code{struct} classes: \cr\cr
\verb{[pls_scores_plot]} >> \verb{[scatter_chart]} >> \verb{[chart]} >> \verb{[struct_class]}
}

\examples{
M = pls_scores_plot(
      components = NULL,
      xcol = 1,
      ycol = 2,
      points_to_label = "none",
      factor_name = "V1",
      ellipse = "all",
      label_filter = character(0),
      label_factor = "rownames",
      label_size = 3.88,
      ellipse_type = "norm",
      ellipse_confidence = 0.95)

D = iris_DatasetExperiment()
M = mean_centre()+PLSDA(factor_name='Species')
M = model_apply(M,D)

C = pls_scores_plot(factor_name='Species')
chart_plot(C,M[2])
}
