% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumBatchCorEval.R
\name{plotClusterEvalStats}
\alias{plotClusterEvalStats}
\title{Compare and evaluate different batch corrected data with plotting.}
\usage{
plotClusterEvalStats(
  spe_list,
  bio_feature_name,
  batch_feature_name,
  data_names,
  colors = NA
)
}
\arguments{
\item{spe_list}{A list of Spatial Experiment object.}

\item{bio_feature_name}{The common biological variation name.}

\item{batch_feature_name}{The common batch variation name.}

\item{data_names}{Data names.}

\item{colors}{Color values of filing the bars.}
}
\value{
A ggplot object.
}
\description{
Compare and evaluate different batch corrected data with plotting.
}
\examples{
library(scater)
data("dkd_spe_subset")
spe <- dkd_spe_subset
spe2 <- spe
spe3 <- spe
plotClusterEvalStats(list(spe, spe2, spe3),
  bio_feature_name = "region",
  batch_feature_name = "SlideName", c("test1", "test2", "test3")
)
}
