% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getSignificantTx}
\alias{getSignificantTx}
\alias{getSignificantTx}
\alias{getSignificantTx,stageR}
\alias{getSignificantTx,stageRTx}
\title{Return significant transcripts when performing transcript-level analysis.}
\usage{
getSignificantTx(object, ...)

\S4method{getSignificantTx}{stageRTx}(object)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}
}
\value{
A matrix of significant transcripts with their corresponding stage-wise adjusted p-value (i.e. FDR and FWER correction).
}
\description{
This functions returns a matrix with significant transctripts according to a stage-wise analysis.
}
\examples{
#make identifiers linking transcripts to genes
set.seed(1)
genes=paste0("gene",sample(1:200,1000,replace=TRUE))
nGenes=length(table(genes))
transcripts=paste0("tx",1:1000)
tx2gene=data.frame(transcripts,genes)
#gene-wise q-values
pScreen=c(seq(1e-10,1e-2,length.out=nGenes-100),seq(1e-2,.2,length.out=50),seq(50))
names(pScreen)=names(table(genes)) #discards genes that are not simulated
pConfirmation=matrix(runif(1000),nrow=1000,ncol=1)
rownames(pConfirmation)=transcripts
stageRObj <- stageRTx(pScreen=pScreen, pConfirmation=pConfirmation ,pScreenAdjusted=TRUE, tx2gene=tx2gene)
stageRObj <- stageWiseAdjustment(stageRObj, method="dte", alpha=0.05)
head(getSignificantTx(stageRObj))
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
