% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods.R
\docType{class}
\name{srnadiffExp}
\alias{srnadiffExp}
\alias{srnadiffExp-class}
\alias{show,srnadiffExp-method}
\title{Infrastructure for sRNA-Seq experiment and differential expression}
\usage{
srnadiffExp(
  bamFiles = NULL,
  sampleInfo = NULL,
  annotReg = NULL,
  diffMethod = NULL,
  normFactors = NULL
)

\S4method{show}{srnadiffExp}(object)
}
\arguments{
\item{bamFiles}{A vector with the full paths to the BAM files.}

\item{sampleInfo}{A \code{data.frame} with three columns labelled
\code{FileName}, \code{SampleName} and \code{Condition}.
The first column is the BAM file name (without extension),
the second column the sample name, and the third column
the condition to which sample belongs. Each row describes
one sample.}

\item{annotReg}{Optional annotation information. Annotated regions as a
\code{GRanges} object. By example, ranges in the output
from \code{\link{readAnnotation}}.}

\item{diffMethod}{A character storing the name of the method used
to compute the p-values. Can be \code{DESeq2} (default), 
or \code{edgeR}.}

\item{normFactors}{A numeric vector, one size factor for each sample in the
data.}

\item{object}{An \code{srnadiffExp} object.}
}
\value{
\code{srnadiffExp} constructor returns an \code{srnadiffExp}
        object of class S4.

The \code{show} method informatively display object contents.
}
\description{
\code{srnadiffExp} is an S4 class providing the infrastructure (slots)
to store the input data, methods parameters, intermediate calculations
and results of a sRNA-diff approach.
}
\details{
\code{srnadiffExp} load and summarize sample BAM
files into base-resolution coverage and estimate the size factors (the
effective library size) from the coverage data.

To facilitate programming pipelines, \code{NULL} values are input
for \code{regions}, \code{parameters} and \code{countMatrix} slots,
in which case the default value is used as if the argument had been
missing. These slots will be updated after differential expression
(\code{\link{srnadiff}}) approach.
}
\section{Slots}{

\describe{
\item{\code{bamFiles}}{A \code{\link[Rsamtools]{BamFileList}} object
with the full paths to the BAM files.}

\item{\code{sampleInfo}}{A \code{data.frame} with sample and experimental
design information. Each row describes one sample.}

\item{\code{annotReg}}{A \code{GRanges} with annotation information.}

\item{\code{diffMethod}}{A character storing the name of the method used
to compute the p-values. Can be \code{DESeq2}, 
or \code{edgeR}.}

\item{\code{chromosomeSizes}}{A named vector with the sizes of the chromosomes.}

\item{\code{coverages}}{The sample coverages, a named
\code{\link[IRanges]{RleList}} object.}

\item{\code{normFactors}}{A vector of normalization factors.}

\item{\code{regions}}{A \code{GenomicRanges} of the candidate
differentially expressed regions.}

\item{\code{countMatrix}}{A matrix of non-negative integer count values,
one row per region and one column per sample.}

\item{\code{parameters}}{An named \code{list}. The parameters for the
segmentation methods. See \code{\link{parameters}}.}
}}

\examples{
basedir    <- system.file("extdata", package="srnadiff", mustWork = TRUE)
sampleInfo <- read.csv(file.path(basedir, "dataInfo.csv"))
gtfFile    <- file.path(basedir, "Homo_sapiens.GRCh38.76.gtf.gz")
annotReg   <- readAnnotation(gtfFile, feature="gene", source="miRNA")
bamFiles   <- file.path(basedir, sampleInfo$FileName)

srnaExp <- srnadiffExp(bamFiles, sampleInfo, annotReg)
srnaExp

}
