% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\docType{methods}
\name{regions}
\alias{regions}
\alias{regions,srnadiffExp-method}
\title{Extracts differentially expressed regions of an srnadiffExp object}
\usage{
\S4method{regions}{srnadiffExp}(object, pvalue = 1)
}
\arguments{
\item{object}{An \code{srnadiffExp} object.}

\item{pvalue}{Numeric cutoff value for adjusted p-values. Only regions with
adjusted p-values equal or lower than specified are returned.
Default to 1, all regions are returned.}
}
\value{
A \code{GenomicRanges} object of the selected differentially
expressed regions.
}
\description{
This function extracts the differentially expressed regions from
\code{\link{srnadiffExp}} object ranked by p-value.
}
\examples{
srnaExp <- srnadiffExample()
srnaExp <- srnadiff(srnaExp)
regions(srnaExp, pvalue = 0.05)

}
