% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelFeatsFunctions.R
\name{labelFeatsLasso}
\alias{labelFeatsLasso}
\title{Label similar chromatographic features in bulk via interactive selection}
\usage{
labelFeatsLasso(
  peak_data,
  ms1_data = NULL,
  rt_window_width = 1,
  ppm_window_width = 5,
  verbosity = 1
)
}
\arguments{
\item{peak_data}{Flat-form XC-MS data with columns for the bounding box of
a chromatographic peak (mzmin, mzmax, rtmin, rtmax) as grouped by a feature
ID. Must be provided WITHOUT retention time correction for proper matching
to the values in the raw data.}

\item{ms1_data}{Optional data.table object produced by RaMS containing MS1
data with columns for filename, rt, mz, and int. If not provided, the files
are detected from the filepath column in peak_data.}

\item{rt_window_width}{The width of the retention time window that should
be used for PCA construction, in minutes.}

\item{ppm_window_width}{The width of the m/z window that should be used for
PCA construction, in parts per million.}

\item{verbosity}{Scalar value between zero and two determining how much
diagnostic information is produced. 0 should return nothing, 1 should
return text-based progress markers, and 2 will return diagnostic plots if
available.}
}
\value{
A character vector named with feature IDs containing the classifications
of each peak that was viewed during the interactive phase. NA values indicate
those features that were not classified.
}
\description{
This function interpolates multi-file chromatograms to a shared set of retention
time points then performs a PCA to place similar chromatograms near each other
in a reduced dimensionality space. Features can then be labeled in groups
instead of one at a time, massively reducing the burden of creating a
high-quality dataset. This implementation relies on R's \pkg{shiny} package
to provide interactive support in a browser environment and the
\pkg{plotly} package for selection tools. Classified features are then
returned as a simple R object for downstream use.
}
\examples{
library(xcms)
library(dplyr)
library(MSnbase)
mzML_files <- system.file("extdata", package = "RaMS") \%>\%
    list.files(full.names = TRUE, pattern = "[A-F].mzML")
register(BPPARAM = SerialParam())
cwp <- CentWaveParam(snthresh = 0, extendLengthMSW = TRUE, integrate = 2)
obp <- ObiwarpParam(binSize = 0.1, response = 1, distFun = "cor_opt")
pdp <- PeakDensityParam(
    sampleGroups = 1:3, bw = 12, minFraction = 0,
    binSize = 0.001, minSamples = 0
)
xcms_filled <- mzML_files \%>\%
    readMSData(msLevel. = 1, mode = "onDisk") \%>\%
    findChromPeaks(cwp) \%>\%
    adjustRtime(obp) \%>\%
    groupChromPeaks(pdp) \%>\%
    fillChromPeaks(FillChromPeaksParam(ppm = 5))
peak_data <- makeXcmsObjFlat(xcms_filled)
if (interactive()) {
    lasso_labels <- labelFeatsLasso(peak_data)
}
}
