% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb-simulate.R
\name{zinbSimulate}
\alias{zinbSimulate}
\title{ZINB-WaVE simulation}
\usage{
zinbSimulate(params = newZINBParams(), sparsify = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{params}{ZINBParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate counts using the ZINB-WaVE method.
}
\details{
This function is just a wrapper around \code{\link[zinbwave]{zinbSim}} that
takes a \code{\link{ZINBParams}}, runs the simulation then converts the
output to a \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.
See \code{\link[zinbwave]{zinbSim}} and the ZINB-WaVE paper for
more details about how the simulation works.
}
\examples{
if (requireNamespace("zinbwave", quietly = TRUE)) {
    sim <- zinbSimulate()
}

}
\references{
Campbell K, Yau C. Uncovering genomic trajectories with heterogeneous genetic
and environmental backgrounds across single-cells and populations. bioRxiv
(2017).

Risso D, Perraudeau F, Gribkova S, Dudoit S, Vert J-P. ZINB-WaVE: A general
and flexible method for signal extraction from single-cell RNA-seq data
bioRxiv (2017).

Paper: \url{10.1101/125112}

Code: \url{https://github.com/drisso/zinbwave}
}
