% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splatPop-estimate.R
\name{splatPopEstimateMeanCV}
\alias{splatPopEstimateMeanCV}
\title{Estimate gene mean and gene mean variance parameters}
\usage{
splatPopEstimateMeanCV(params, emp.gene.means)
}
\arguments{
\item{params}{SplatPopParams object containing parameters for the
simulation of the mean expression levels for the population.
See \code{\link{SplatPopParams}} for details.}

\item{emp.gene.means}{data.frame of empirical gene means across a population,
where rows are genes and columns are individuals.}
}
\value{
params object with estimated values.
}
\description{
Estimate gene mean and gene mean variance parameters
}
\details{
Parameters for the mean gamma distribution are estimated by fitting the mean
(across the population) expression of genes that meet the criteria (<50% of
samples have exp <0.1) and parameters for the cv gamma distribution are
estimated for each bin of mean expression using the cv of expression across
the population for genes in that bin. Both are fit using
\code{\link[fitdistrplus]{fitdist}}. The "Nelder-Mead" method is used to fit
the mean gamma distribution and the maximum goodness-of-fit estimation
method is used to minimise the Cramer-von Mises distance for the CV
distribution.
}
\keyword{internal}
