% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfa-estimate.R
\name{mfaEstimate}
\alias{mfaEstimate}
\alias{mfaEstimate.SingleCellExperiment}
\alias{mfaEstimate.matrix}
\title{Estimate mfa simulation parameters}
\usage{
mfaEstimate(counts, params = newMFAParams())

\method{mfaEstimate}{SingleCellExperiment}(counts, params = newMFAParams())

\method{mfaEstimate}{matrix}(counts, params = newMFAParams())
}
\arguments{
\item{counts}{either a counts matrix or a SingleCellExperiment object
containing count data to estimate parameters from.}

\item{params}{MFAParams object to store estimated values in.}
}
\value{
MFAParams object containing the estimated parameters.
}
\description{
Estimate simulation parameters for the mfa simulation from a real dataset.
}
\details{
The \code{nGenes} and \code{nCells} parameters are taken from the size of the
input data. The dropout lambda parameter is estimate using
\code{\link[mfa]{empirical_lambda}}. See \code{\link{MFAParams}} for more
details on the parameters.
}
\examples{
# Load example data
if (requireNamespace("mfa", quietly = TRUE)) {
    library(mfa)
    synth <- create_synthetic(
        C = 20, G = 5, zero_negative = TRUE,
        model_dropout = TRUE
    )

    params <- mfaEstimate(synth$X)
    params
}
}
