% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{makeOverallPanel}
\alias{makeOverallPanel}
\title{Make overall panel}
\usage{
makeOverallPanel(
  comp,
  diff,
  title = "Overall comparison",
  row.labels = c("Means", "Variance", "Mean-variance relationship", "Library size",
    "Zeros per cell", "Zeros per gene", "Mean-zeros relationship")
)
}
\arguments{
\item{comp}{list returned by \code{\link{compareSCEs}}.}

\item{diff}{list returned by \code{\link{diffSCEs}}.}

\item{title}{title for the panel.}

\item{row.labels}{vector of labels for each of the seven rows.}
}
\value{
Combined panel plot
}
\description{
Combine the plots from \code{compSCEs} and \code{diffSCEs} into a
single panel.
}
\examples{
\donttest{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
comparison <- compareSCEs(list(Splat = sim1, Simple = sim2))
difference <- diffSCEs(list(Splat = sim1, Simple = sim2), ref = "Simple")
panel <- makeOverallPanel(comparison, difference)
}

}
