% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{makeDiffPanel}
\alias{makeDiffPanel}
\title{Make difference panel}
\usage{
makeDiffPanel(
  diff,
  title = "Difference comparison",
  labels = c("Means", "Variance", "Library size", "Zeros per cell", "Zeros per gene",
    "Mean-variance relationship", "Mean-zeros relationship")
)
}
\arguments{
\item{diff}{list returned by \code{\link{diffSCEs}}.}

\item{title}{title for the panel.}

\item{labels}{vector of labels for each of the seven sections.}
}
\value{
Combined panel plot
}
\description{
Combine the plots from \code{diffSCEs} into a single panel.
}
\examples{
\donttest{
sim1 <- splatSimulate(nGenes = 1000, batchCells = 20)
sim2 <- simpleSimulate(nGenes = 1000, nCells = 20)
difference <- diffSCEs(list(Splat = sim1, Simple = sim2), ref = "Simple")
panel <- makeDiffPanel(difference)
}

}
