% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-simulate.R
\name{kersplatSimulate}
\alias{kersplatSimulate}
\title{Kersplat simulation}
\usage{
kersplatSimulate(
  params = newKersplatParams(),
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{params}{KersplatParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts and intermediate
values
}
\description{
Simulate scRNA-seq count data using the Kersplat model
}
\details{
This functions is for simulating data in a single step. It consists of a
call to \code{\link{kersplatSetup}} followed by a call to
\code{\link{kersplatSample}}. Please see the documentation for those
functions for more details of the individual steps.
}
\examples{

if (requireNamespace("igraph", quietly = TRUE)) {
    sim <- kersplatSimulate
}

}
\seealso{
\code{\link{kersplatSetup}}, \code{\link{kersplatSample}}
}
