% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{SplatParams}
\alias{SplatParams}
\alias{SplatParams-class}
\title{The SplatParams class}
\description{
S4 class that holds parameters for the Splat simulation.
}
\section{Parameters}{


The Splat simulation requires the following parameters:

\describe{
    \item{\code{nGenes}}{The number of genes to simulate.}
    \item{\code{nCells}}{The number of cells to simulate.}
    \item{\code{[seed]}}{Seed to use for generating random numbers.}
    \item{\emph{Batch parameters}}{
        \describe{
            \item{\code{[nBatches]}}{The number of batches to simulate.}
            \item{\code{[batchCells]}}{Vector giving the number of cells in
            each batch.}
            \item{\code{[batch.facLoc]}}{Location (meanlog) parameter for the
            batch effect factor log-normal distribution. Can be a vector.}
            \item{\code{[batch.facScale]}}{Scale (sdlog) parameter for the
            batch effect factor log-normal distribution. Can be a vector.}
            \item{\code{[batch.rmEffect]}}{Logical, removes the batch effect
            and continues with the simulation when TRUE. This allows the
            user to test batch removal algorithms without having to calculate
            the new expected cell means with batch removed.}
        }
    }
    \item{\emph{Mean parameters}}{
        \describe{
            \item{\code{mean.shape}}{Shape parameter for the mean gamma
            distribution.}
            \item{\code{mean.rate}}{Rate parameter for the mean gamma
            distribution.}
        }
    }
    \item{\emph{Library size parameters}}{
        \describe{
            \item{\code{lib.loc}}{Location (meanlog) parameter for the
            library size log-normal distribution, or mean parameter if a
            normal distribution is used.}
            \item{\code{lib.scale}}{Scale (sdlog) parameter for the library
            size log-normal distribution, or sd parameter if a normal
            distribution is used.}
            \item{\code{lib.norm}}{Logical. Whether to use a normal
            distribution for library sizes instead of a log-normal.}
        }
    }
    \item{\emph{Expression outlier parameters}}{
        \describe{
            \item{\code{out.prob}}{Probability that a gene is an expression
            outlier.}
            \item{\code{out.facLoc}}{Location (meanlog) parameter for the
            expression outlier factor log-normal distribution.}
            \item{\code{out.facScale}}{Scale (sdlog) parameter for the
            expression outlier factor log-normal distribution.}
        }
    }
    \item{\emph{Group parameters}}{
        \describe{
            \item{\code{[nGroups]}}{The number of groups or paths to
            simulate.}
            \item{\code{[group.prob]}}{Probability that a cell comes from a
            group.}
        }
    }
    \item{\emph{Differential expression parameters}}{
        \describe{
            \item{\code{[de.prob]}}{Probability that a gene is differentially
            expressed in a group. Can be a vector.}
            \item{\code{[de.downProb]}}{Probability that a differentially
            expressed gene is down-regulated. Can be a vector.}
            \item{\code{[de.facLoc]}}{Location (meanlog) parameter for the
            differential expression factor log-normal distribution. Can be a
            vector.}
            \item{\code{[de.facScale]}}{Scale (sdlog) parameter for the
            differential expression factor log-normal distribution. Can be a
            vector.}
        }
    }
    \item{\emph{Biological Coefficient of Variation parameters}}{
        \describe{
            \item{\code{bcv.common}}{Underlying common dispersion across all
            genes.}
            \item{\code{bcv.df}}{Degrees of Freedom for the BCV inverse
            chi-squared distribution.}
        }
    }
    \item{\emph{Dropout parameters}}{
        \describe{
            \item{\code{dropout.type}}{The type of dropout to simulate.
            "none" indicates no dropout, "experiment" is global dropout using
            the same parameters for every cell, "batch" uses the same
            parameters for every cell in each batch, "group" uses the same
            parameters for every cell in each groups and "cell" uses a
            different set of parameters for each cell.}
            \item{\code{dropout.mid}}{Midpoint parameter for the dropout
            logistic function.}
            \item{\code{dropout.shape}}{Shape parameter for the dropout
            logistic function.}
        }
    }
    \item{\emph{Differentiation path parameters}}{
        \describe{
            \item{\code{[path.from]}}{Vector giving the originating point of
            each path. This allows path structure such as a cell type which
            differentiates into an intermediate cell type that then
            differentiates into two mature cell types. A path structure of
            this form would have a "from" parameter of c(0, 1, 1) (where 0 is
            the origin). If no vector is given all paths will start at the
            origin.}
            \item{\code{[path.nSteps]}}{Vector giving the number of steps to
            simulate along each path. If a single value is given it will be
            applied to all paths. This parameter was previously called
            \code{path.length}.}
            \item{\code{[path.skew]}}{Vector giving the skew of each path.
            Values closer to 1 will give more cells towards the starting
            population, values closer to 0 will give more cells towards the
            final population. If a single value is given it will be applied
            to all paths.}
            \item{\code{[path.nonlinearProb]}}{Probability that a gene
            follows a non-linear path along the differentiation path. This
            allows more complex gene patterns such as a gene being equally
            expressed at the beginning an end of a path but lowly expressed
            in the middle.}
            \item{\code{[path.sigmaFac]}}{Sigma factor for non-linear gene
            paths. A higher value will result in more extreme non-linear
            variations along a path.}
    }
  }
}

The parameters not shown in brackets can be estimated from real data using
\code{\link{splatEstimate}}. For details of the Splat simulation
see \code{\link{splatSimulate}}.
}

