% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{Lun2Params}
\alias{Lun2Params}
\alias{Lun2Params-class}
\title{The Lun2Params class}
\description{
S4 class that holds parameters for the Lun2 simulation.
}
\section{Parameters}{


The Lun2 simulation uses the following parameters:

\describe{
    \item{\code{nGenes}}{The number of genes to simulate.}
    \item{\code{nCells}}{The number of cells to simulate.}
    \item{\code{[seed]}}{Seed to use for generating random numbers.}
    \item{\emph{Gene parameters}}{
        \describe{
            \item{\code{gene.params}}{A \code{data.frame} containing gene
            parameters with two columns: \code{Mean} (mean expression for
            each gene) and \code{Disp} (dispersion for each gene).}
            \item{\code{zi.params}}{A \code{data.frame} containing
            zero-inflated gene parameters with three columns: \code{Mean}
            (mean expression for each gene), \code{Disp} (dispersion for
            each, gene), and \code{Prop} (zero proportion for each gene).}
        }
    }
    \item{\code{[nPlates]}}{The number of plates to simulate.}
    \item{\emph{Plate parameters}}{
        \describe{
            \item{\code{plate.ingroup}}{Character vector giving the plates
            considered to be part of the "ingroup".}
            \item{\code{plate.mod}}{Plate effect modifier factor. The plate
            effect variance is divided by this value.}
            \item{\code{plate.var}}{Plate effect variance.}
        }
    }
    \item{\emph{Cell parameters}}{
        \describe{
            \item{\code{cell.plates}}{Factor giving the plate that each cell
            comes from.}
            \item{\code{cell.libSizes}}{Library size for each cell.}
            \item{\code{cell.libMod}}{Modifier factor for library sizes.
            The library sizes are multiplied by this value.}
        }
    }
    \item{\emph{Differential expression parameters}}{
        \describe{
            \item{\code{de.nGenes}}{Number of differentially expressed
            genes.}
            \item{\code{de.fc}}{Fold change for differentially expressed
            genes.}
    }
  }
}

The parameters not shown in brackets can be estimated from real data using
\code{\link{lun2Estimate}}. For details of the Lun2 simulation see
\code{\link{lun2Simulate}}.
}

